/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.parsers;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.InstallationMode;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginPermission;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptorFactory;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.XmlDescriptorParserUtils;
import com.atlassian.plugin.util.PluginUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDescriptorParser
implements DescriptorParser {
    private static final Logger log = LoggerFactory.getLogger(XmlDescriptorParser.class);
    private final Document document;
    private final Set<Application> applications;

    public XmlDescriptorParser(Document source, Set<Application> applications) throws PluginParseException {
        this.document = XmlDescriptorParserUtils.removeAllNamespaces((Document)Preconditions.checkNotNull((Object)source, (Object)"XML descriptor source document cannot be null"));
        this.applications = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(applications)));
    }

    public XmlDescriptorParser(InputStream source, Set<Application> applications) throws PluginParseException {
        this(XmlDescriptorParser.createDocument((InputStream)Preconditions.checkNotNull((Object)source, (Object)"XML descriptor source cannot be null")), applications);
    }

    protected static Document createDocument(InputStream source) throws PluginParseException {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        try {
            return reader.read(source);
        }
        catch (DocumentException e) {
            throw new PluginParseException("Cannot parse XML plugin descriptor", e);
        }
    }

    protected Document getDocument() {
        return this.document;
    }

    @Override
    public Plugin configurePlugin(ModuleDescriptorFactory moduleDescriptorFactory, Plugin plugin) throws PluginParseException {
        Element pluginElement = this.getPluginElement();
        plugin.setName(pluginElement.attributeValue("name"));
        plugin.setKey(this.getKey());
        plugin.setPluginsVersion(this.getPluginsVersion());
        plugin.setSystemPlugin(this.isSystemPlugin());
        if (pluginElement.attributeValue("i18n-name-key") != null) {
            plugin.setI18nNameKey(pluginElement.attributeValue("i18n-name-key"));
        }
        if (plugin.getKey().indexOf(":") > 0) {
            throw new PluginParseException("Plugin keys cannot contain ':'. Key is '" + plugin.getKey() + "'");
        }
        if ("disabled".equalsIgnoreCase(pluginElement.attributeValue("state"))) {
            plugin.setEnabledByDefault(false);
        }
        plugin.setResources(Resources.fromXml(pluginElement));
        Iterator i = pluginElement.elementIterator();
        while (i.hasNext()) {
            ModuleDescriptor<?> moduleDescriptor;
            Element element = (Element)i.next();
            if ("plugin-info".equalsIgnoreCase(element.getName())) {
                plugin.setPluginInformation(this.createPluginInformation(element));
                continue;
            }
            if ("resource".equalsIgnoreCase(element.getName()) || (moduleDescriptor = this.createModuleDescriptor(plugin, element, moduleDescriptorFactory)) == null) continue;
            if (plugin.getModuleDescriptor(moduleDescriptor.getKey()) != null) {
                throw new PluginParseException("Found duplicate key '" + moduleDescriptor.getKey() + "' within plugin '" + plugin.getKey() + "'");
            }
            plugin.addModuleDescriptor(moduleDescriptor);
            if (!(moduleDescriptor instanceof UnloadableModuleDescriptor)) continue;
            log.error("There were errors loading the plugin '" + plugin.getName() + "'. The plugin has been disabled.");
            return UnloadablePluginFactory.createUnloadablePlugin(plugin);
        }
        return plugin;
    }

    private Element getPluginElement() {
        return this.document.getRootElement();
    }

    protected ModuleDescriptor<?> createModuleDescriptor(Plugin plugin, Element element, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        ModuleDescriptor<?> moduleDescriptorDescriptor;
        String name = element.getName();
        if (!PluginUtils.doesModuleElementApplyToApplication(element, this.applications, plugin.getInstallationMode())) {
            log.debug("Ignoring module descriptor for this application: " + element.attributeValue("key"));
            return null;
        }
        try {
            moduleDescriptorDescriptor = moduleDescriptorFactory.getModuleDescriptor(name);
        }
        catch (Throwable e) {
            UnrecognisedModuleDescriptor descriptor = UnrecognisedModuleDescriptorFactory.createUnrecognisedModuleDescriptor(plugin, element, e, moduleDescriptorFactory);
            log.error("There were problems loading the module '" + name + "' in plugin '" + plugin.getName() + "'. The module has been disabled.");
            log.error(descriptor.getErrorText(), e);
            return descriptor;
        }
        if (moduleDescriptorDescriptor == null) {
            log.info("The module '" + name + "' in plugin '" + plugin.getName() + "' is in the list of excluded module descriptors, so not enabling.");
            return null;
        }
        try {
            moduleDescriptorDescriptor.init(plugin, element);
        }
        catch (Exception e) {
            UnloadableModuleDescriptor descriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, element, e, moduleDescriptorFactory);
            log.error("There were problems loading the module '" + name + "'. The module and its plugin have been disabled.");
            log.error(descriptor.getErrorText(), (Throwable)e);
            return descriptor;
        }
        return moduleDescriptorDescriptor;
    }

    protected PluginInformation createPluginInformation(Element element) {
        PluginInformation pluginInfo = new PluginInformation();
        if (element.element("description") != null) {
            pluginInfo.setDescription(element.element("description").getTextTrim());
            if (element.element("description").attributeValue("key") != null) {
                pluginInfo.setDescriptionKey(element.element("description").attributeValue("key"));
            }
        }
        if (element.element("version") != null) {
            pluginInfo.setVersion(element.element("version").getTextTrim());
        }
        if (element.element("vendor") != null) {
            Element vendor = element.element("vendor");
            pluginInfo.setVendorName(vendor.attributeValue("name"));
            pluginInfo.setVendorUrl(vendor.attributeValue("url"));
        }
        for (Element param : this.getElements(element, "param")) {
            if (param.attribute("name") == null) continue;
            pluginInfo.addParameter(param.attribute("name").getData().toString(), param.getText());
        }
        if (element.element("application-version") != null) {
            Element ver = element.element("application-version");
            if (ver.attribute("max") != null) {
                pluginInfo.setMaxVersion(Float.parseFloat(ver.attributeValue("max")));
            }
            if (ver.attribute("min") != null) {
                pluginInfo.setMinVersion(Float.parseFloat(ver.attributeValue("min")));
            }
        }
        if (element.element("java-version") != null) {
            pluginInfo.setMinJavaVersion(Float.valueOf(element.element("java-version").attributeValue("min")));
        }
        if (element.element("permissions") != null) {
            ImmutableSet.Builder permissions = ImmutableSet.builder();
            for (Element permission : Iterables.filter(this.getElements(element.element("permissions"), "permission"), (Predicate)new ElementWithForApplicationsPredicate(this.applications))) {
                String trimmedPermission = permission.getTextTrim();
                if (StringUtils.isNotBlank((String)trimmedPermission)) {
                    String parsedInstallationMode = permission.attributeValue("installation-mode");
                    Option<InstallationMode> installationMode = InstallationMode.of(parsedInstallationMode);
                    if (StringUtils.isNotBlank((String)parsedInstallationMode) && !installationMode.isDefined()) {
                        log.warn("The parsed installation mode '{}' for permission '{}' didn't match any of the valid values: {}", new Object[]{parsedInstallationMode, trimmedPermission, Iterables.transform((Iterable)ImmutableList.copyOf((Object[])InstallationMode.values()), (Function)new Function<InstallationMode, String>(){

                            public String apply(InstallationMode im) {
                                return im.getKey();
                            }
                        })});
                    }
                    permissions.add((Object)new PluginPermission(trimmedPermission, installationMode));
                    continue;
                }
                log.warn("Plugin {} has blank permission.", (Object)this.getKey());
            }
            pluginInfo.setPermissions((Set<PluginPermission>)permissions.build());
        } else if (this.getPluginsVersion() < 3) {
            pluginInfo.setPermissions((Set<PluginPermission>)ImmutableSet.of((Object)PluginPermission.ALL));
        }
        return pluginInfo;
    }

    @Override
    public String getKey() {
        return this.getPluginElement().attributeValue("key");
    }

    @Override
    public int getPluginsVersion() {
        String val = this.getPluginElement().attributeValue("pluginsVersion");
        if (val == null) {
            val = this.getPluginElement().attributeValue("plugins-version");
        }
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not parse pluginsVersion: " + e.getMessage(), e);
            }
        }
        return 1;
    }

    @Override
    public PluginInformation getPluginInformation() {
        return this.createPluginInformation(this.getDocument().getRootElement().element("plugin-info"));
    }

    @Override
    public boolean isSystemPlugin() {
        return Boolean.valueOf(this.getPluginElement().attributeValue("system"));
    }

    private List<Element> getElements(Element element, String name) {
        return element.elements(name);
    }

    private static final class ElementWithForApplicationsPredicate
    implements Predicate<Element> {
        private final Set<Application> applications;

        private ElementWithForApplicationsPredicate(Set<Application> applications) {
            this.applications = (Set)Preconditions.checkNotNull(applications);
        }

        public boolean apply(Element el) {
            String appName = el.attributeValue("application");
            return appName == null || Iterables.any(this.applications, (Predicate)new ApplicationWithNamePredicate(appName));
        }
    }

    private static final class ApplicationWithNamePredicate
    implements Predicate<Application> {
        private final String name;

        public ApplicationWithNamePredicate(String name) {
            this.name = name;
        }

        public boolean apply(Application app) {
            return app.getKey().equals(this.name);
        }
    }
}

