/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactBackedPlugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.loaders.ForwardingPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public final class PermissionCheckingPluginLoader
extends ForwardingPluginLoader {
    public PermissionCheckingPluginLoader(PluginLoader delegate) {
        super(delegate);
    }

    @Override
    public Iterable<Plugin> loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.delegate().loadAllPlugins(moduleDescriptorFactory), (Function)new CheckPluginPermissionFunction()));
    }

    @Override
    public Iterable<Plugin> loadFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.delegate().loadFoundPlugins(moduleDescriptorFactory), (Function)new CheckPluginPermissionFunction()));
    }

    private static final class CheckPluginPermissionFunction
    implements Function<Plugin, Plugin> {
        private CheckPluginPermissionFunction() {
        }

        public Plugin apply(Plugin p) {
            if (!p.getActivePermissions().contains("execute_java")) {
                return p;
            }
            if (p instanceof PluginArtifactBackedPlugin) {
                return this.checkPlugin((PluginArtifactBackedPlugin)p);
            }
            return p;
        }

        private Plugin checkPlugin(PluginArtifactBackedPlugin p) {
            PluginArtifact pluginArtifact = p.getPluginArtifact();
            if (pluginArtifact.containsJavaExecutableCode()) {
                UnloadablePlugin unloadablePlugin = new UnloadablePlugin("Plugin doesn't require 'execute_java' permission yet references some java executable code. This could be either embedded java classes, embedded java libraries, spring context files or bundle activator.");
                unloadablePlugin.setKey(p.getKey());
                unloadablePlugin.setName(p.getName());
                return unloadablePlugin;
            }
            return p;
        }
    }
}

