/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathPluginLoader
implements PluginLoader {
    private static Logger log = LoggerFactory.getLogger(ClassPathPluginLoader.class);
    private final String fileNameToLoad;
    private Iterable<Plugin> plugins;

    public ClassPathPluginLoader() {
        this("atlassian-plugin.xml");
    }

    public ClassPathPluginLoader(String fileNameToLoad) {
        this.fileNameToLoad = fileNameToLoad;
    }

    private void loadClassPathPlugins(final ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Enumeration<URL> pluginDescriptorFiles;
        try {
            pluginDescriptorFiles = ClassLoaderUtils.getResources(this.fileNameToLoad, this.getClass());
        }
        catch (IOException e) {
            log.error("Could not load classpath plugins: " + e, (Throwable)e);
            return;
        }
        this.plugins = Iterables.concat((Iterable)ImmutableList.copyOf((Iterator)Iterators.transform((Iterator)Iterators.forEnumeration(pluginDescriptorFiles), (Function)new Function<URL, Iterable<Plugin>>(){

            public Iterable<Plugin> apply(@Nullable URL url) {
                return new SinglePluginLoader(url).loadAllPlugins(moduleDescriptorFactory);
            }
        })));
    }

    @Override
    public Iterable<Plugin> loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        if (this.plugins == null) {
            this.loadClassPathPlugins(moduleDescriptorFactory);
        }
        return ImmutableList.copyOf(this.plugins);
    }

    @Override
    public boolean supportsRemoval() {
        return false;
    }

    @Override
    public boolean supportsAddition() {
        return false;
    }

    @Override
    public boolean isDynamicPluginLoader() {
        return false;
    }

    @Override
    public Iterable<Plugin> loadFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        throw new UnsupportedOperationException("This PluginLoader does not support addition.");
    }

    @Override
    public void removePlugin(Plugin plugin) throws PluginException {
        throw new PluginException("This PluginLoader does not support removal.");
    }
}

