/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.factories;

import com.atlassian.plugin.Application;
import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginFactory
implements PluginFactory {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final DescriptorParserFactory descriptorParserFactory;
    protected final Set<Application> applications;

    protected AbstractPluginFactory(DescriptorParserFactory descriptorParserFactory, Set<Application> applications) {
        this.descriptorParserFactory = (DescriptorParserFactory)Preconditions.checkNotNull((Object)descriptorParserFactory);
        this.applications = (Set)Preconditions.checkNotNull(applications);
    }

    @Override
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        return this.getPluginKeyFromDescriptor(pluginArtifact);
    }

    @Override
    @Deprecated
    public final Plugin create(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        return this.create(new JarPluginArtifact(((DeploymentUnit)Preconditions.checkNotNull((Object)deploymentUnit)).getPath()), moduleDescriptorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getPluginKeyFromDescriptor(PluginArtifact pluginArtifact) {
        String pluginKey = null;
        InputStream descriptorStream = null;
        try {
            descriptorStream = this.getDescriptorInputStream(pluginArtifact);
            if (descriptorStream != null) {
                DescriptorParser descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream, this.applications);
                if (this.isValidPluginsVersion().apply((Object)descriptorParser.getPluginsVersion())) {
                    pluginKey = descriptorParser.getKey();
                }
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)descriptorStream);
        }
        return pluginKey;
    }

    protected abstract InputStream getDescriptorInputStream(PluginArtifact var1);

    protected abstract Predicate<Integer> isValidPluginsVersion();
}

