/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import org.apache.commons.lang.StringUtils;

public class ModuleCompleteKey {
    private static final String SEPARATOR = ":";
    private final String pluginKey;
    private final String moduleKey;

    public ModuleCompleteKey(String completeKey) {
        this(StringUtils.substringBefore((String)completeKey, (String)SEPARATOR), StringUtils.substringAfter((String)completeKey, (String)SEPARATOR));
    }

    public ModuleCompleteKey(String pluginKey, String moduleKey) {
        this.pluginKey = StringUtils.trimToEmpty((String)pluginKey);
        if (!this.isValidKey(this.pluginKey)) {
            throw new IllegalArgumentException("Invalid plugin key specified: " + this.pluginKey);
        }
        this.moduleKey = StringUtils.trimToEmpty((String)moduleKey);
        if (!this.isValidKey(this.moduleKey)) {
            throw new IllegalArgumentException("Invalid module key specified: " + this.moduleKey);
        }
    }

    private boolean isValidKey(String key) {
        return StringUtils.isNotBlank((String)key) && !key.contains(SEPARATOR);
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getCompleteKey() {
        return this.pluginKey + SEPARATOR + this.moduleKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleCompleteKey that = (ModuleCompleteKey)o;
        if (!this.moduleKey.equals(that.moduleKey)) {
            return false;
        }
        return this.pluginKey.equals(that.pluginKey);
    }

    public int hashCode() {
        int result = this.pluginKey.hashCode();
        result = 31 * result + this.moduleKey.hashCode();
        return result;
    }

    public String toString() {
        return this.getCompleteKey();
    }
}

