/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.DefaultPluginArtifactFactory;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactFactory;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.loaders.DynamicPluginLoader;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.Scanner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanningPluginLoader
implements DynamicPluginLoader {
    private static final Logger log = LoggerFactory.getLogger(ScanningPluginLoader.class);
    protected final Scanner scanner;
    protected final Map<DeploymentUnit, Plugin> plugins;
    protected final List<PluginFactory> pluginFactories;
    protected final PluginArtifactFactory pluginArtifactFactory;

    public ScanningPluginLoader(Scanner scanner, List<PluginFactory> pluginFactories, PluginEventManager pluginEventManager) {
        this(scanner, pluginFactories, new DefaultPluginArtifactFactory(), pluginEventManager);
    }

    public ScanningPluginLoader(Scanner scanner, List<PluginFactory> pluginFactories, PluginArtifactFactory pluginArtifactFactory, PluginEventManager pluginEventManager) {
        Preconditions.checkNotNull(pluginFactories, (Object)"The list of plugin factories must be specified");
        Preconditions.checkNotNull((Object)pluginEventManager, (Object)"The event manager must be specified");
        Preconditions.checkNotNull((Object)scanner, (Object)"The scanner must be specified");
        this.plugins = new TreeMap<DeploymentUnit, Plugin>();
        this.pluginArtifactFactory = pluginArtifactFactory;
        this.scanner = scanner;
        this.pluginFactories = new ArrayList<PluginFactory>(pluginFactories);
        pluginEventManager.register(this);
    }

    @Override
    public Iterable<Plugin> loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        this.scanner.scan();
        for (DeploymentUnit deploymentUnit : this.scanner.getDeploymentUnits()) {
            Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
            plugin = this.postProcess(plugin);
            this.plugins.put(deploymentUnit, plugin);
        }
        if (this.scanner.getDeploymentUnits().isEmpty()) {
            log.info("No plugins found to be deployed");
        }
        return ImmutableList.copyOf(this.plugins.values());
    }

    @Override
    public Iterable<Plugin> loadFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Collection<DeploymentUnit> updatedDeploymentUnits = this.scanner.scan();
        ArrayList<Plugin> foundPlugins = new ArrayList<Plugin>();
        for (DeploymentUnit deploymentUnit : updatedDeploymentUnits) {
            if (this.plugins.containsKey(deploymentUnit)) continue;
            Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
            plugin = this.postProcess(plugin);
            this.plugins.put(deploymentUnit, plugin);
            foundPlugins.add(plugin);
        }
        if (foundPlugins.isEmpty()) {
            log.info("No plugins found to be installed");
        }
        return ImmutableList.copyOf(foundPlugins);
    }

    @Override
    public boolean supportsRemoval() {
        return true;
    }

    @Override
    public boolean supportsAddition() {
        return true;
    }

    protected final Plugin deployPluginFromUnit(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) {
        Plugin plugin = null;
        String errorText = "No plugin factories found for plugin file " + deploymentUnit;
        String pluginKey = null;
        for (PluginFactory factory : this.pluginFactories) {
            try {
                PluginArtifact artifact = this.pluginArtifactFactory.create(deploymentUnit.getPath().toURI());
                pluginKey = factory.canCreate(artifact);
                if (pluginKey == null || (plugin = factory.create(artifact, moduleDescriptorFactory)) == null) continue;
                log.debug("Plugin factory '{}' created plugin '{}'.", (Object)factory.getClass().getName(), (Object)pluginKey);
            }
            catch (Throwable ex) {
                log.error("Unable to deploy plugin '{}' from '{}'.", pluginKey, (Object)deploymentUnit);
                log.error("Because of the following exception:", ex);
                errorText = ex.getMessage();
            }
            break;
        }
        if (plugin == null) {
            plugin = new UnloadablePlugin(errorText);
            if (pluginKey != null) {
                plugin.setKey(pluginKey);
            } else {
                plugin.setKey(deploymentUnit.getPath().getName());
            }
            log.debug("Could not find a suitable factory for plugin '{}' of '{}'", (Object)pluginKey, (Object)deploymentUnit);
        } else {
            log.debug("Plugin '{}' created from '{}'", (Object)plugin.getKey(), (Object)deploymentUnit);
        }
        return plugin;
    }

    @Override
    public void removePlugin(Plugin plugin) throws PluginException {
        if (plugin.getPluginState() == PluginState.ENABLED) {
            throw new PluginException("Cannot remove an enabled plugin");
        }
        if (!plugin.isUninstallable()) {
            throw new PluginException("Cannot remove an uninstallable plugin: [" + plugin.getName() + "]");
        }
        DeploymentUnit deploymentUnit = this.findMatchingDeploymentUnit(plugin);
        plugin.uninstall();
        try {
            boolean found = false;
            for (DeploymentUnit unit : this.plugins.keySet()) {
                if (!unit.getPath().equals(deploymentUnit.getPath()) || unit.equals(deploymentUnit)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.scanner.remove(deploymentUnit);
            }
        }
        catch (SecurityException e) {
            throw new PluginException(e);
        }
        this.plugins.remove(deploymentUnit);
        log.info("Removed plugin " + plugin.getKey());
    }

    private DeploymentUnit findMatchingDeploymentUnit(Plugin plugin) throws PluginException {
        DeploymentUnit deploymentUnit = null;
        for (Map.Entry<DeploymentUnit, Plugin> entry : this.plugins.entrySet()) {
            if (entry.getValue() != plugin) continue;
            deploymentUnit = entry.getKey();
            break;
        }
        if (deploymentUnit == null) {
            throw new PluginException("This pluginLoader has no memory of deploying the plugin you are trying remove: [" + plugin.getName() + "]");
        }
        return deploymentUnit;
    }

    @PluginEventListener
    public void onShutdown(PluginFrameworkShutdownEvent event) {
        Iterator<Plugin> it = this.plugins.values().iterator();
        while (it.hasNext()) {
            Plugin plugin = it.next();
            if (plugin.isUninstallable()) {
                plugin.uninstall();
            }
            it.remove();
        }
        this.scanner.reset();
    }

    @Deprecated
    public void shutDown() {
        this.onShutdown(null);
    }

    @Override
    public boolean isDynamicPluginLoader() {
        return true;
    }

    @Override
    public String canLoad(PluginArtifact pluginArtifact) throws PluginParseException {
        PluginFactory factory;
        String pluginKey = null;
        Iterator<PluginFactory> i$ = this.pluginFactories.iterator();
        while (i$.hasNext() && (pluginKey = (factory = i$.next()).canCreate(pluginArtifact)) == null) {
        }
        return pluginKey;
    }

    protected Plugin postProcess(Plugin plugin) {
        return plugin;
    }
}

