/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.factories;

import com.atlassian.plugin.Application;
import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.classloader.PluginClassLoader;
import com.atlassian.plugin.factories.AbstractPluginFactory;
import com.atlassian.plugin.impl.DefaultDynamicPlugin;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ranges;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class LegacyDynamicPluginFactory
extends AbstractPluginFactory {
    private final String pluginDescriptorFileName;
    private final File tempDirectory;

    public LegacyDynamicPluginFactory(String pluginDescriptorFileName) {
        this(pluginDescriptorFileName, new File(System.getProperty("java.io.tmpdir")));
    }

    public LegacyDynamicPluginFactory(String pluginDescriptorFileName, File tempDirectory) {
        super(new XmlDescriptorParserFactory(), (Set<Application>)ImmutableSet.of());
        this.tempDirectory = (File)Preconditions.checkNotNull((Object)tempDirectory);
        this.pluginDescriptorFileName = (String)Preconditions.checkNotNull((Object)pluginDescriptorFileName);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)pluginDescriptorFileName), (Object)"Plugin descriptor name cannot be null or blank");
    }

    @Override
    protected InputStream getDescriptorInputStream(PluginArtifact pluginArtifact) {
        return pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
    }

    @Override
    protected Predicate<Integer> isValidPluginsVersion() {
        return Ranges.atMost((Comparable)Integer.valueOf(1));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Preconditions.checkNotNull((Object)pluginArtifact, (Object)"The deployment unit must not be null");
        Preconditions.checkNotNull((Object)moduleDescriptorFactory, (Object)"The module descriptor factory must not be null");
        File file = pluginArtifact.toFile();
        Plugin plugin = null;
        InputStream pluginDescriptor = null;
        PluginClassLoader loader = null;
        try {
            pluginDescriptor = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
            if (pluginDescriptor == null) {
                throw new PluginParseException("No descriptor found in classloader for : " + file);
            }
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor, (Set<Application>)ImmutableSet.of());
            loader = new PluginClassLoader(file, Thread.currentThread().getContextClassLoader(), this.tempDirectory);
            plugin = parser.configurePlugin(moduleDescriptorFactory, this.createPlugin(pluginArtifact, loader));
        }
        catch (PluginParseException e) {
            try {
                if (loader == null) throw e;
                loader.close();
                throw e;
                catch (RuntimeException e2) {
                    if (loader == null) throw new PluginParseException(e2);
                    loader.close();
                    throw new PluginParseException(e2);
                }
                catch (Error e3) {
                    if (loader == null) throw e3;
                    loader.close();
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pluginDescriptor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }

    protected Plugin createPlugin(DeploymentUnit deploymentUnit, PluginClassLoader loader) {
        return this.createPlugin(new JarPluginArtifact(deploymentUnit.getPath()), loader);
    }

    protected Plugin createPlugin(PluginArtifact pluginArtifact, PluginClassLoader loader) {
        return new DefaultDynamicPlugin(pluginArtifact, loader);
    }
}

