/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactBackedPlugin;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.AbstractDelegatingPlugin;
import com.atlassian.plugin.loaders.DirectoryScanner;
import com.atlassian.plugin.loaders.FileListScanner;
import com.atlassian.plugin.loaders.ScanningPluginLoader;
import com.atlassian.plugin.loaders.classloading.Scanner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundledPluginLoader
extends ScanningPluginLoader {
    public BundledPluginLoader(URL zipUrl, File pluginPath, List<PluginFactory> pluginFactories, PluginEventManager eventManager) {
        super(BundledPluginLoader.buildScanner(zipUrl, pluginPath), pluginFactories, eventManager);
    }

    @Override
    protected Plugin postProcess(Plugin plugin) {
        if (plugin instanceof PluginArtifactBackedPlugin) {
            return new BundledPluginArtifactBackedPluginDelegate((PluginArtifactBackedPlugin)plugin);
        }
        return new BundledPluginDelegate(plugin);
    }

    private static Scanner buildScanner(URL url, File pluginPath) {
        if (url == null) {
            throw new IllegalArgumentException("Bundled plugins url cannot be null");
        }
        Scanner scanner = null;
        File file = com.atlassian.plugin.util.FileUtils.toFile(url);
        if (file != null) {
            if (file.isDirectory()) {
                scanner = new DirectoryScanner(file);
            } else if (file.isFile() && file.getName().endsWith(".list")) {
                List<File> files = BundledPluginLoader.readListFile(file);
                scanner = new FileListScanner(files);
            }
        }
        if (scanner == null) {
            com.atlassian.plugin.util.FileUtils.conditionallyExtractZipFile(url, pluginPath);
            scanner = new DirectoryScanner(pluginPath);
        }
        return scanner;
    }

    private static List<File> readListFile(File file) {
        try {
            List fnames = FileUtils.readLines((File)file);
            ArrayList<File> files = new ArrayList<File>();
            for (String fname : fnames) {
                files.add(new File(fname));
            }
            return files;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read list from " + file, e);
        }
    }

    private static class BundledPluginArtifactBackedPluginDelegate
    extends BundledPluginDelegate
    implements PluginArtifactBackedPlugin {
        private final PluginArtifactBackedPlugin delegate;

        private BundledPluginArtifactBackedPluginDelegate(PluginArtifactBackedPlugin delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        public PluginArtifact getPluginArtifact() {
            return this.delegate.getPluginArtifact();
        }
    }

    private static class BundledPluginDelegate
    extends AbstractDelegatingPlugin {
        public BundledPluginDelegate(Plugin delegate) {
            super(delegate);
        }

        public boolean isBundledPlugin() {
            return true;
        }

        public boolean isDeleteable() {
            return false;
        }
    }
}

