/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class JarPluginArtifact
implements PluginArtifact {
    private final File jarFile;

    public JarPluginArtifact(File jarFile) {
        Validate.notNull((Object)jarFile);
        this.jarFile = jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesResourceExist(String name) {
        InputStream in = null;
        try {
            in = this.getResourceAsStream(name);
            boolean bl = in != null;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public InputStream getResourceAsStream(String fileName) throws PluginParseException {
        BufferedInputStream descriptorStream;
        ZipEntry entry;
        JarFile jar;
        Validate.notNull((Object)fileName, (String)"The file name must not be null");
        try {
            jar = new JarFile(this.jarFile);
            entry = jar.getEntry(fileName);
            if (entry == null) {
                jar.close();
                return null;
            }
        }
        catch (IOException e) {
            throw new PluginParseException("Cannot open JAR file for reading: " + this.jarFile, e);
        }
        try {
            descriptorStream = new BufferedInputStream(jar.getInputStream(entry)){

                public void close() throws IOException {
                    super.close();
                    jar.close();
                }
            };
        }
        catch (IOException e) {
            throw new PluginParseException("Cannot retrieve " + fileName + " from plugin JAR [" + this.jarFile + "]", e);
        }
        return descriptorStream;
    }

    public String getName() {
        return this.jarFile.getName();
    }

    public String toString() {
        return this.getName();
    }

    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.jarFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not open JAR file for reading: " + this.jarFile, e);
        }
    }

    public File toFile() {
        return this.jarFile;
    }
}

