/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.event.impl;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.AsynchronousAbleEventDispatcher;
import com.atlassian.event.internal.EventExecutorFactoryImpl;
import com.atlassian.event.internal.EventPublisherImpl;
import com.atlassian.event.internal.EventThreadPoolConfigurationImpl;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.EventExecutorFactory;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.AnnotationListenerMethodSelector;
import com.atlassian.plugin.event.impl.ListenerMethodSelector;
import com.atlassian.plugin.event.impl.MethodNameListenerMethodSelector;
import com.atlassian.plugin.event.impl.MethodSelectorListenerHandler;
import com.atlassian.plugin.util.Assertions;
import java.util.ArrayList;
import java.util.List;

public class DefaultPluginEventManager
implements PluginEventManager {
    private final EventPublisher publisher;

    public DefaultPluginEventManager(final ListenerMethodSelector ... selectors) {
        ListenerHandlersConfiguration configuration = new ListenerHandlersConfiguration(){

            public List<ListenerHandler> getListenerHandlers() {
                ArrayList<ListenerHandler> handlers = new ArrayList<ListenerHandler>(selectors.length);
                for (ListenerMethodSelector selector : selectors) {
                    handlers.add(new MethodSelectorListenerHandler(selector));
                }
                return handlers;
            }
        };
        EventExecutorFactoryImpl executorFactory = new EventExecutorFactoryImpl((EventThreadPoolConfiguration)new EventThreadPoolConfigurationImpl());
        AsynchronousAbleEventDispatcher eventDispatcher = new AsynchronousAbleEventDispatcher((EventExecutorFactory)executorFactory);
        this.publisher = new EventPublisherImpl((EventDispatcher)eventDispatcher, configuration);
    }

    public DefaultPluginEventManager() {
        this(DefaultPluginEventManager.defaultMethodSelectors());
    }

    public DefaultPluginEventManager(EventPublisher publisher) {
        this.publisher = Assertions.notNull("publisher", publisher);
    }

    public void register(Object listener) {
        this.publisher.register(Assertions.notNull("listener", listener));
    }

    public void unregister(Object listener) {
        this.publisher.unregister(Assertions.notNull("listener", listener));
    }

    public void broadcast(Object event) throws NotificationException {
        Assertions.notNull("event", event);
        try {
            this.publisher.publish(event);
        }
        catch (RuntimeException e) {
            throw new NotificationException(e);
        }
    }

    static ListenerMethodSelector[] defaultMethodSelectors() {
        MethodNameListenerMethodSelector methodNames = new MethodNameListenerMethodSelector();
        AnnotationListenerMethodSelector pluginEvent = new AnnotationListenerMethodSelector();
        AnnotationListenerMethodSelector eventListener = new AnnotationListenerMethodSelector(EventListener.class);
        return new ListenerMethodSelector[]{methodNames, pluginEvent, eventListener};
    }
}

