/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.event.impl;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.AsynchronousAbleEventDispatcher;
import com.atlassian.event.internal.EventExecutorFactoryImpl;
import com.atlassian.event.internal.EventPublisherImpl;
import com.atlassian.event.internal.EventThreadPoolConfigurationImpl;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.EventExecutorFactory;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.AnnotationListenerMethodSelector;
import com.atlassian.plugin.event.impl.ListenerMethodSelector;
import com.atlassian.plugin.event.impl.MethodNameListenerMethodSelector;
import com.atlassian.plugin.event.impl.MethodSelectorListenerHandler;
import java.util.ArrayList;
import java.util.List;

public class DefaultPluginEventManager
implements PluginEventManager {
    private final EventPublisher publisher;

    public DefaultPluginEventManager(final ListenerMethodSelector[] selectors) {
        ListenerHandlersConfiguration configuration = new ListenerHandlersConfiguration(){

            public List<ListenerHandler> getListenerHandlers() {
                ArrayList<ListenerHandler> handlers = new ArrayList<ListenerHandler>(selectors.length);
                for (ListenerMethodSelector selector : selectors) {
                    handlers.add(new MethodSelectorListenerHandler(selector));
                }
                return handlers;
            }
        };
        EventThreadPoolConfigurationImpl threadPoolConfiguration = new EventThreadPoolConfigurationImpl();
        EventExecutorFactoryImpl factory = new EventExecutorFactoryImpl((EventThreadPoolConfiguration)threadPoolConfiguration);
        AsynchronousAbleEventDispatcher dispatcher = new AsynchronousAbleEventDispatcher((EventExecutorFactory)factory);
        this.publisher = new EventPublisherImpl((EventDispatcher)dispatcher, configuration);
    }

    public DefaultPluginEventManager() {
        this(new ListenerMethodSelector[]{new MethodNameListenerMethodSelector(), new AnnotationListenerMethodSelector(), new AnnotationListenerMethodSelector(EventListener.class)});
    }

    public DefaultPluginEventManager(EventPublisher publisher) {
        this.publisher = publisher;
    }

    public void register(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.publisher.register(listener);
    }

    public void unregister(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.publisher.unregister(listener);
    }

    public void broadcast(Object event) throws NotificationException {
        try {
            this.publisher.publish(event);
        }
        catch (RuntimeException e) {
            throw new NotificationException(e);
        }
    }
}

