/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.descriptors.RequiresRestart;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUtils {
    public static final String ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    public static final String ATLASSIAN_PLUGINS_ENABLE_WAIT = "atlassian.plugins.enable.wait";

    public static boolean doesPluginRequireRestart(Plugin plugin) {
        if (Boolean.getBoolean(ATLASSIAN_DEV_MODE)) {
            return false;
        }
        for (ModuleDescriptor<?> descriptor : plugin.getModuleDescriptors()) {
            if (descriptor.getClass().getAnnotation(RequiresRestart.class) == null) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getPluginModulesThatRequireRestart(Plugin plugin) {
        HashSet<String> keys = new HashSet<String>();
        for (ModuleDescriptor<?> descriptor : plugin.getModuleDescriptors()) {
            if (descriptor.getClass().getAnnotation(RequiresRestart.class) == null) continue;
            keys.add(descriptor.getKey());
        }
        return keys;
    }

    public static boolean doesModuleElementApplyToApplication(Element element, Set<String> keys) {
        Validate.notNull(keys);
        Validate.notNull((Object)element);
        String key = element.attributeValue("application");
        return key == null || keys.contains(key);
    }

    public static int getDefaultEnablingWaitPeriod() {
        return Integer.parseInt(System.getProperty(ATLASSIAN_PLUGINS_ENABLE_WAIT, "60"));
    }
}

