/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util.resource;

import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativeDirectoryResourceLoader
implements AlternativeResourceLoader {
    private final List<File> resourceDirectories;
    private static final Log log = LogFactory.getLog(AlternativeDirectoryResourceLoader.class);
    public static final String PLUGIN_RESOURCE_DIRECTORIES = "plugin.resource.directories";

    public AlternativeDirectoryResourceLoader() {
        String dirs = System.getProperty(PLUGIN_RESOURCE_DIRECTORIES);
        ArrayList<File> tmp = new ArrayList<File>();
        if (dirs != null) {
            for (String dir : dirs.split(",")) {
                File file = new File(dir);
                if (file.exists()) {
                    log.info((Object)("Found alternative resource directory " + dir));
                    tmp.add(file);
                    continue;
                }
                log.warn((Object)("Resource directory " + dir + ", which resolves to " + file.getAbsolutePath() + " does not exist"));
            }
        }
        this.resourceDirectories = Collections.unmodifiableList(tmp);
    }

    @Override
    public URL getResource(String path) {
        for (File dir : this.resourceDirectories) {
            File file = new File(dir, path);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException e) {
                    log.error((Object)("Malformed URL: " + file.toString()), (Throwable)e);
                    continue;
                }
            }
            log.debug((Object)("File " + file + " not found, ignoring"));
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                log.error((Object)("Unable to open URL " + url), (Throwable)e);
            }
        }
        return null;
    }

    public List<File> getResourceDirectories() {
        return this.resourceDirectories;
    }
}

