/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util.zip;

import com.atlassian.plugin.util.zip.AbstractUnzipper;
import com.atlassian.plugin.util.zip.StreamUnzipper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUnzipper
extends AbstractUnzipper {
    private static final Log log = LogFactory.getLog(FileUnzipper.class);
    private File zipFile;
    private File destDir;

    public FileUnzipper(File zipFile, File destDir) {
        this.zipFile = zipFile;
        this.destDir = destDir;
    }

    public void unzip() throws IOException {
        if (this.zipFile == null || !this.zipFile.isFile()) {
            return;
        }
        this.getStreamUnzipper().unzip();
    }

    public ZipEntry[] entries() throws IOException {
        return this.getStreamUnzipper().entries();
    }

    public File unzipFileInArchive(String fileName) throws IOException {
        File result = null;
        if (this.zipFile == null || !this.zipFile.isFile() || !StringUtils.isNotEmpty((String)fileName)) {
            return result;
        }
        result = this.getStreamUnzipper().unzipFileInArchive(fileName);
        if (result == null) {
            log.error((Object)("The file: " + fileName + " could not be found in the archive: " + this.zipFile.getAbsolutePath()));
        }
        return result;
    }

    private StreamUnzipper getStreamUnzipper() throws FileNotFoundException {
        return new StreamUnzipper(new BufferedInputStream(new FileInputStream(this.zipFile)), this.destDir);
    }
}

