/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.event.impl;

import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.AnnotationListenerMethodSelector;
import com.atlassian.plugin.event.impl.ListenerMethodSelector;
import com.atlassian.plugin.event.impl.MethodNameListenerMethodSelector;
import com.atlassian.plugin.util.ClassUtils;
import com.atlassian.plugin.util.collect.Function;
import com.atlassian.plugin.util.concurrent.CopyOnWriteMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultPluginEventManager
implements PluginEventManager {
    private static final Log log = LogFactory.getLog(DefaultPluginEventManager.class);
    private final EventsToListener eventsToListener = new EventsToListener();
    private final ListenerMethodSelector[] listenerMethodSelectors;

    public DefaultPluginEventManager() {
        this(new ListenerMethodSelector[]{new MethodNameListenerMethodSelector(), new AnnotationListenerMethodSelector()});
    }

    public DefaultPluginEventManager(ListenerMethodSelector[] selectors) {
        this.listenerMethodSelectors = selectors;
    }

    public void broadcast(Object event) throws NotificationException {
        Validate.notNull((Object)event, (String)"The event to broadcast must not be null");
        HashSet<Listener> calledListeners = new HashSet<Listener>();
        ArrayList<Throwable> allErrors = new ArrayList<Throwable>();
        for (Class type : ClassUtils.findAllTypes(event.getClass())) {
            Set<Listener> registrations = this.eventsToListener.get(type);
            if (registrations == null) continue;
            for (Listener reg : registrations) {
                if (calledListeners.contains(reg)) continue;
                calledListeners.add(reg);
                try {
                    reg.notify(event);
                }
                catch (NotificationException ex) {
                    allErrors.add(ex.getCause());
                }
            }
        }
        if (!allErrors.isEmpty()) {
            throw new NotificationException(allErrors);
        }
    }

    public void register(Object listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        final AtomicBoolean listenerFound = new AtomicBoolean(false);
        this.forEveryListenerMethod(listener, new ListenerMethodHandler(){

            public void handle(Object listener, Method m) {
                if (m.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Listener methods must only have one argument");
                }
                Set<Listener> listeners = DefaultPluginEventManager.this.eventsToListener.get(m.getParameterTypes()[0]);
                listeners.add(new Listener(listener, m));
                listenerFound.set(true);
            }
        });
        if (!listenerFound.get()) {
            throw new IllegalArgumentException("At least one listener method must be specified.  Most likely, a listener method is missing the @PluginEventListener annotation.");
        }
    }

    public void unregister(Object listener) {
        this.forEveryListenerMethod(listener, new ListenerMethodHandler(){

            public void handle(Object listener, Method m) {
                Set<Listener> listeners = DefaultPluginEventManager.this.eventsToListener.get(m.getParameterTypes()[0]);
                listeners.remove(new Listener(listener, m));
            }
        });
    }

    void forEveryListenerMethod(Object listener, ListenerMethodHandler handler) {
        Method[] methods;
        for (Method m : methods = listener.getClass().getMethods()) {
            for (ListenerMethodSelector selector : this.listenerMethodSelectors) {
                if (!selector.isListenerMethod(m)) continue;
                handler.handle(listener, m);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EventsToListener
    implements Function<Class<?>, Set<Listener>> {
        private final ConcurrentMap<Class<?>, Set<Listener>> map = CopyOnWriteMap.newHashMap();

        EventsToListener() {
        }

        @Override
        public Set<Listener> get(Class<?> input) {
            Set result = (Set)this.map.get(input);
            while (result == null) {
                this.map.putIfAbsent(input, new CopyOnWriteArraySet());
                result = (Set)this.map.get(input);
            }
            return result;
        }
    }

    private static class Listener {
        public final Object listener;
        public final Method method;

        public Listener(Object listener, Method method) {
            Validate.notNull((Object)listener);
            Validate.notNull((Object)method);
            this.listener = listener;
            this.method = method;
        }

        public void notify(Object event) throws NotificationException {
            Validate.notNull((Object)event);
            try {
                this.method.invoke(this.listener, event);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Unable to access listener method: " + this.method), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)("Plugin Event Listener '" + this.listener + "' threw an error on event '" + event + "': " + e.getCause().getMessage()), e.getCause());
                throw new NotificationException(e.getCause());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Listener that = (Listener)o;
            if (!this.listener.equals(that.listener)) {
                return false;
            }
            return this.method.equals(that.method);
        }

        public int hashCode() {
            int result = this.listener.hashCode();
            result = 31 * result + this.method.hashCode();
            return result;
        }
    }

    private static interface ListenerMethodHandler {
        public void handle(Object var1, Method var2);
    }
}

