/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util;

import java.util.concurrent.TimeUnit;

public class Timeout {
    private static final TimeSupplier NANO_SUPPLIER = new TimeSupplier(){

        public long currentTime() {
            return System.nanoTime();
        }

        public TimeUnit precision() {
            return TimeUnit.NANOSECONDS;
        }
    };
    private static final TimeSupplier MILLIS_SUPPLIER = new TimeSupplier(){

        public long currentTime() {
            return System.currentTimeMillis();
        }

        public TimeUnit precision() {
            return TimeUnit.MILLISECONDS;
        }
    };
    private final long created;
    private final long time;
    private final TimeSupplier supplier;

    public static Timeout getNanosTimeout(long time, TimeUnit unit) {
        return new Timeout(time, unit, NANO_SUPPLIER);
    }

    public static Timeout getMillisTimeout(long time, TimeUnit unit) {
        return new Timeout(time, unit, MILLIS_SUPPLIER);
    }

    Timeout(long time, TimeUnit unit, TimeSupplier supplier) {
        this.created = supplier.currentTime();
        this.supplier = supplier;
        this.time = this.supplier.precision().convert(time, unit);
    }

    public long getTime() {
        return this.created + this.time - this.supplier.currentTime();
    }

    public TimeUnit getUnit() {
        return this.supplier.precision();
    }

    public String getRemaining() {
        return TimeUnit.SECONDS.convert(this.getTime(), this.getUnit()) + " seconds remaining";
    }

    public boolean isExpired() {
        return this.getTime() <= 0L;
    }

    static interface TimeSupplier {
        public long currentTime();

        public TimeUnit precision();
    }
}

