/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.PluginSystemLifecycle;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.classloader.PluginsClassLoader;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartingEvent;
import com.atlassian.plugin.event.events.PluginFrameworkWarmRestartedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkWarmRestartingEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.loaders.DynamicPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.manager.PluginEnabler;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.manager.StateTracker;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.EnabledPluginPredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfClassPredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfTypePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.predicate.ModuleOfClassPredicate;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.util.PluginUtils;
import com.atlassian.plugin.util.collect.CollectionUtil;
import com.atlassian.plugin.util.collect.Function;
import com.atlassian.plugin.util.concurrent.CopyOnWriteMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginManager
implements PluginController,
PluginAccessor,
PluginSystemLifecycle {
    private static final Log log = LogFactory.getLog(DefaultPluginManager.class);
    private final List<PluginLoader> pluginLoaders;
    private final PluginPersistentStateStore store;
    private final ModuleDescriptorFactory moduleDescriptorFactory;
    private final PluginEventManager pluginEventManager;
    private final Map<String, Plugin> plugins = CopyOnWriteMap.newHashMap();
    private final PluginsClassLoader classLoader = new PluginsClassLoader(this);
    private final PluginEnabler pluginEnabler = new PluginEnabler(this, this);
    private final StateTracker tracker = new StateTracker();
    private PluginInstaller pluginInstaller;
    private final Map<Plugin, PluginLoader> pluginToPluginLoader = new HashMap<Plugin, PluginLoader>();

    public DefaultPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager) {
        this.pluginLoaders = Assertions.notNull("Plugin Loaders list must not be null.", pluginLoaders);
        this.store = Assertions.notNull("PluginPersistentStateStore must not be null.", store);
        this.moduleDescriptorFactory = Assertions.notNull("ModuleDescriptorFactory must not be null.", moduleDescriptorFactory);
        this.pluginEventManager = Assertions.notNull("PluginEventManager must not be null.", pluginEventManager);
        this.pluginEventManager.register(this);
    }

    @Override
    public void init() throws PluginParseException, NotificationException {
        this.tracker.setState(StateTracker.State.STARTING);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        log.info((Object)"Initialising the plugin system");
        this.pluginEventManager.broadcast(new PluginFrameworkStartingEvent(this, this));
        for (PluginLoader loader : this.pluginLoaders) {
            if (loader == null) continue;
            Collection<Plugin> possiblePluginsToLoad = loader.loadAllPlugins(this.moduleDescriptorFactory);
            ArrayList<Plugin> pluginsToLoad = new ArrayList<Plugin>();
            for (Plugin plugin : possiblePluginsToLoad) {
                if (this.getState().getPluginRestartState(plugin.getKey()) == PluginRestartState.REMOVE) {
                    loader.removePlugin(plugin);
                    this.removeStateFromStore(this.getStore(), plugin);
                    continue;
                }
                pluginsToLoad.add(plugin);
            }
            this.addPlugins(loader, pluginsToLoad);
        }
        this.getStore().save(this.getBuilder().clearPluginRestartState().toState());
        this.pluginEventManager.broadcast(new PluginFrameworkStartedEvent(this, this));
        stopWatch.stop();
        log.info((Object)("Plugin system started in " + stopWatch));
        this.tracker.setState(StateTracker.State.STARTED);
    }

    @Override
    public void shutdown() {
        this.tracker.setState(StateTracker.State.SHUTTING_DOWN);
        log.info((Object)"Shutting down the plugin system");
        this.pluginEventManager.broadcast(new PluginFrameworkShutdownEvent(this, this));
        this.plugins.clear();
        this.pluginEventManager.unregister(this);
        this.tracker.setState(StateTracker.State.SHUTDOWN);
    }

    @Override
    public final void warmRestart() {
        this.tracker.setState(StateTracker.State.WARM_RESTARTING);
        log.info((Object)"Initiating a warm restart of the plugin system");
        this.pluginEventManager.broadcast(new PluginFrameworkWarmRestartingEvent(this, this));
        ArrayList<Plugin> restartedPlugins = new ArrayList<Plugin>();
        ArrayList<PluginLoader> loaders = new ArrayList<PluginLoader>(this.pluginLoaders);
        Collections.reverse(loaders);
        for (PluginLoader loader : this.pluginLoaders) {
            for (Map.Entry<Plugin, PluginLoader> entry : this.pluginToPluginLoader.entrySet()) {
                Plugin plugin;
                if (entry.getValue() != loader || !this.isPluginEnabled((plugin = entry.getKey()).getKey())) continue;
                this.disablePluginModules(plugin);
                restartedPlugins.add(plugin);
            }
        }
        Collections.reverse(restartedPlugins);
        for (Plugin plugin : restartedPlugins) {
            this.enablePluginModules(plugin);
        }
        this.classLoader.notifyPluginOrModuleEnabled();
        this.pluginEventManager.broadcast(new PluginFrameworkWarmRestartedEvent(this, this));
        this.tracker.setState(StateTracker.State.STARTED);
    }

    @PluginEventListener
    public void onPluginRefresh(PluginRefreshedEvent event) {
        Plugin plugin = event.getPlugin();
        this.disablePluginModules(plugin);
        this.classLoader.notifyPluginOrModuleEnabled();
        if (this.enablePluginModules(plugin)) {
            this.pluginEventManager.broadcast(new PluginEnabledEvent(plugin));
        }
    }

    public void setPluginInstaller(PluginInstaller pluginInstaller) {
        this.pluginInstaller = pluginInstaller;
    }

    protected final PluginPersistentStateStore getStore() {
        return this.store;
    }

    @Override
    public String installPlugin(PluginArtifact pluginArtifact) throws PluginParseException {
        Set<String> keys = this.installPlugins(pluginArtifact);
        if (keys != null && keys.size() == 1) {
            return keys.iterator().next();
        }
        throw new PluginParseException("Could not install plugin");
    }

    @Override
    public Set<String> installPlugins(PluginArtifact ... pluginArtifacts) throws PluginParseException {
        LinkedHashMap<String, PluginArtifact> validatedArtifacts = new LinkedHashMap<String, PluginArtifact>();
        try {
            for (PluginArtifact pluginArtifact : pluginArtifacts) {
                validatedArtifacts.put(this.validatePlugin(pluginArtifact), pluginArtifact);
            }
        }
        catch (PluginParseException ex) {
            throw new PluginParseException("All plugins could not validated", ex);
        }
        for (Map.Entry entry : validatedArtifacts.entrySet()) {
            this.pluginInstaller.installPlugin((String)entry.getKey(), (PluginArtifact)entry.getValue());
        }
        this.scanForNewPlugins();
        return validatedArtifacts.keySet();
    }

    String validatePlugin(PluginArtifact pluginArtifact) throws PluginParseException {
        boolean foundADynamicPluginLoader = false;
        for (PluginLoader loader : this.pluginLoaders) {
            if (!(loader instanceof DynamicPluginLoader)) continue;
            foundADynamicPluginLoader = true;
            String key = ((DynamicPluginLoader)loader).canLoad(pluginArtifact);
            if (key == null) continue;
            return key;
        }
        if (!foundADynamicPluginLoader) {
            throw new IllegalStateException("Should be at least one DynamicPluginLoader in the plugin loader list");
        }
        throw new PluginParseException("Jar " + pluginArtifact.getName() + " is not a valid plugin");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int scanForNewPlugins() throws PluginParseException {
        int numberFound = 0;
        Iterator<PluginLoader> i$ = this.pluginLoaders.iterator();
        while (i$.hasNext()) {
            PluginLoader loader = i$.next();
            if (loader == null || !loader.supportsAddition()) continue;
            ArrayList<Plugin> pluginsToAdd = new ArrayList<Plugin>();
            for (Plugin plugin : loader.addFoundPlugins(this.moduleDescriptorFactory)) {
                block7: {
                    Plugin oldPlugin = this.plugins.get(plugin.getKey());
                    if (plugin instanceof UnloadablePlugin) continue;
                    if (PluginUtils.doesPluginRequireRestart(plugin)) {
                        if (oldPlugin == null) {
                            this.getStore().save(this.getBuilder().setPluginRestartState(plugin.getKey(), PluginRestartState.INSTALL).toState());
                            UnloadablePlugin unloadablePlugin = new UnloadablePlugin("Plugin requires a restart of the application");
                            unloadablePlugin.setKey(plugin.getKey());
                            plugin = unloadablePlugin;
                            break block7;
                        } else {
                            this.getStore().save(this.getBuilder().setPluginRestartState(plugin.getKey(), PluginRestartState.UPGRADE).toState());
                            continue;
                        }
                    }
                    if (oldPlugin != null && PluginUtils.doesPluginRequireRestart(oldPlugin)) {
                        this.getStore().save(this.getBuilder().setPluginRestartState(plugin.getKey(), PluginRestartState.UPGRADE).toState());
                        continue;
                    }
                }
                pluginsToAdd.add(plugin);
            }
            this.addPlugins(loader, pluginsToAdd);
            numberFound = pluginsToAdd.size();
        }
        return numberFound;
    }

    @Override
    public void uninstall(Plugin plugin) throws PluginException {
        if (PluginUtils.doesPluginRequireRestart(plugin)) {
            this.ensurePluginAndLoaderSupportsUninstall(plugin);
            this.getStore().save(this.getBuilder().setPluginRestartState(plugin.getKey(), PluginRestartState.REMOVE).toState());
        } else {
            this.unloadPlugin(plugin);
            this.removeStateFromStore(this.getStore(), plugin);
        }
    }

    protected void removeStateFromStore(PluginPersistentStateStore stateStore, Plugin plugin) {
        PluginPersistentState.Builder builder = PluginPersistentState.Builder.create(stateStore.load()).removeState(plugin.getKey());
        for (ModuleDescriptor<?> moduleDescriptor : plugin.getModuleDescriptors()) {
            builder.removeState(moduleDescriptor.getCompleteKey());
        }
        stateStore.save(builder.toState());
    }

    protected void unloadPlugin(Plugin plugin) throws PluginException {
        PluginLoader loader = this.ensurePluginAndLoaderSupportsUninstall(plugin);
        if (this.isPluginEnabled(plugin.getKey())) {
            this.notifyPluginDisabled(plugin);
        }
        this.notifyUninstallPlugin(plugin);
        if (loader != null) {
            this.removePluginFromLoader(plugin);
        }
        this.plugins.remove(plugin.getKey());
    }

    private PluginLoader ensurePluginAndLoaderSupportsUninstall(Plugin plugin) {
        if (!plugin.isUninstallable()) {
            throw new PluginException("Plugin is not uninstallable: " + plugin.getKey());
        }
        PluginLoader loader = this.pluginToPluginLoader.get(plugin);
        if (loader != null && !loader.supportsRemoval()) {
            throw new PluginException("Not uninstalling plugin - loader doesn't allow removal. Plugin: " + plugin.getKey());
        }
        return loader;
    }

    private void removePluginFromLoader(Plugin plugin) throws PluginException {
        if (plugin.isDeleteable()) {
            PluginLoader pluginLoader = this.pluginToPluginLoader.get(plugin);
            pluginLoader.removePlugin(plugin);
        }
        this.pluginToPluginLoader.remove(plugin);
    }

    protected void notifyUninstallPlugin(Plugin plugin) {
        this.classLoader.notifyUninstallPlugin(plugin);
        for (ModuleDescriptor<?> descriptor : plugin.getModuleDescriptors()) {
            descriptor.destroy(plugin);
        }
    }

    protected PluginPersistentState getState() {
        return this.getStore().load();
    }

    @Deprecated
    protected void addPlugin(PluginLoader loader, Plugin plugin) throws PluginParseException {
        this.addPlugins(loader, Collections.singletonList(plugin));
    }

    protected void addPlugins(PluginLoader loader, Collection<Plugin> pluginsToInstall) throws PluginParseException {
        HashSet<Plugin> pluginsToEnable = new HashSet<Plugin>();
        for (Plugin plugin : new TreeSet<Plugin>(pluginsToInstall)) {
            boolean pluginUpgraded = false;
            if (this.plugins.containsKey(plugin.getKey())) {
                Plugin existingPlugin = this.plugins.get(plugin.getKey());
                if (plugin.compareTo(existingPlugin) >= 0) {
                    try {
                        this.updatePlugin(existingPlugin, plugin);
                        pluginsToEnable.remove(existingPlugin);
                        pluginUpgraded = true;
                    }
                    catch (PluginException e) {
                        throw new PluginParseException("Duplicate plugin found (installed version is the same or older) and could not be unloaded: '" + plugin.getKey() + "'", e);
                    }
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Duplicate plugin found (installed version is newer): '" + plugin.getKey() + "'"));
                    continue;
                }
            }
            plugin.install();
            if (this.getState().isEnabled(plugin)) {
                pluginsToEnable.add(plugin);
            }
            if (pluginUpgraded) {
                this.pluginEventManager.broadcast(new PluginUpgradedEvent(plugin));
            }
            this.plugins.put(plugin.getKey(), plugin);
            this.pluginToPluginLoader.put(plugin, loader);
        }
        this.pluginEnabler.enable(pluginsToEnable);
        for (Plugin plugin : pluginsToInstall) {
            if (plugin.getPluginState() != PluginState.ENABLED || !this.enablePluginModules(plugin)) continue;
            this.pluginEventManager.broadcast(new PluginEnabledEvent(plugin));
        }
    }

    protected void updatePlugin(Plugin oldPlugin, Plugin newPlugin) throws PluginException {
        if (!oldPlugin.getKey().equals(newPlugin.getKey())) {
            throw new IllegalArgumentException("New plugin must have the same key as the old plugin");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Updating plugin '" + oldPlugin + "' to '" + newPlugin + "'"));
        }
        HashMap<String, Boolean> oldPluginState = new HashMap<String, Boolean>(this.getState().getPluginStateMap(oldPlugin));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Uninstalling old plugin: " + oldPlugin));
        }
        this.uninstall(oldPlugin);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Plugin uninstalled '" + oldPlugin + "', preserving old state"));
        }
        final HashSet<String> newModuleKeys = new HashSet<String>();
        newModuleKeys.add(newPlugin.getKey());
        for (ModuleDescriptor<?> moduleDescriptor : newPlugin.getModuleDescriptors()) {
            newModuleKeys.add(moduleDescriptor.getCompleteKey());
        }
        CollectionUtils.filter(oldPluginState.keySet(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return newModuleKeys.contains(o);
            }
        });
        this.getStore().save(this.getBuilder().addState(oldPluginState).toState());
    }

    @Override
    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    @Override
    public Collection<Plugin> getPlugins(final PluginPredicate pluginPredicate) {
        return CollectionUtil.toList(CollectionUtil.filter(this.getPlugins(), new com.atlassian.plugin.util.collect.Predicate<Plugin>(){

            @Override
            public boolean evaluate(Plugin plugin) {
                return pluginPredicate.matches(plugin);
            }
        }));
    }

    @Override
    public Collection<Plugin> getEnabledPlugins() {
        return this.getPlugins(new EnabledPluginPredicate(this));
    }

    @Override
    public <M> Collection<M> getModules(ModuleDescriptorPredicate<M> moduleDescriptorPredicate) {
        Collection<ModuleDescriptor<M>> moduleDescriptors = this.getModuleDescriptors(moduleDescriptorPredicate);
        return this.getModules(moduleDescriptors);
    }

    @Override
    public <M> Collection<ModuleDescriptor<M>> getModuleDescriptors(final ModuleDescriptorPredicate<M> moduleDescriptorPredicate) {
        List<ModuleDescriptor<M>> moduleDescriptors = this.getModuleDescriptorsList(this.getPlugins());
        return CollectionUtil.toList(CollectionUtil.filter(moduleDescriptors, new com.atlassian.plugin.util.collect.Predicate<ModuleDescriptor<M>>(){

            @Override
            public boolean evaluate(ModuleDescriptor<M> input) {
                return moduleDescriptorPredicate.matches(input);
            }
        }));
    }

    private <M> List<ModuleDescriptor<M>> getModuleDescriptorsList(Collection<Plugin> plugins) {
        LinkedList<ModuleDescriptor<M>> moduleDescriptors = new LinkedList<ModuleDescriptor<M>>();
        for (Plugin plugin : plugins) {
            Collection<ModuleDescriptor<?>> descriptors = plugin.getModuleDescriptors();
            Iterator<ModuleDescriptor<?>> i$ = descriptors.iterator();
            while (i$.hasNext()) {
                ModuleDescriptor<?> moduleDescriptor;
                ModuleDescriptor<?> typedDescriptor = moduleDescriptor = i$.next();
                moduleDescriptors.add(typedDescriptor);
            }
        }
        return moduleDescriptors;
    }

    private <M> List<M> getModules(Iterable<ModuleDescriptor<M>> moduleDescriptors) {
        final HashSet pluginsToDisable = new HashSet();
        List modules = CollectionUtil.transform(moduleDescriptors, new Function<ModuleDescriptor<M>, M>(){

            @Override
            public M get(ModuleDescriptor<M> input) {
                Object result = null;
                try {
                    result = input.getModule();
                }
                catch (RuntimeException ex) {
                    log.error((Object)("Exception when retrieving plugin module " + input.getKey() + ", will disable plugin " + input.getPlugin().getKey()), (Throwable)ex);
                    pluginsToDisable.add(input.getPlugin().getKey());
                }
                return result;
            }
        });
        for (String badPluginKey : pluginsToDisable) {
            this.disablePlugin(badPluginKey);
        }
        return modules;
    }

    @Override
    public Plugin getPlugin(String key) {
        return this.plugins.get(key);
    }

    @Override
    public Plugin getEnabledPlugin(String pluginKey) {
        if (!this.isPluginEnabled(pluginKey)) {
            return null;
        }
        return this.getPlugin(pluginKey);
    }

    @Override
    public ModuleDescriptor<?> getPluginModule(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        Plugin plugin = this.getPlugin(key.getPluginKey());
        if (plugin == null) {
            return null;
        }
        return plugin.getModuleDescriptor(key.getModuleKey());
    }

    @Override
    public ModuleDescriptor<?> getEnabledPluginModule(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        if (!this.isPluginModuleEnabled(completeKey)) {
            return null;
        }
        return this.getEnabledPlugin(key.getPluginKey()).getModuleDescriptor(key.getModuleKey());
    }

    @Override
    public <M> List<M> getEnabledModulesByClass(Class<M> moduleClass) {
        return this.getModules(this.getEnabledModuleDescriptorsByModuleClass(moduleClass));
    }

    @Override
    @Deprecated
    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>>[] descriptorClasses, Class<M> moduleClass) {
        Iterable<ModuleDescriptor<M>> moduleDescriptors = DefaultPluginManager.filterModuleDescriptors(this.getEnabledModuleDescriptorsByModuleClass(moduleClass), new ModuleDescriptorOfClassPredicate<M>(descriptorClasses));
        return this.getModules(moduleDescriptors);
    }

    @Override
    @Deprecated
    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>> descriptorClass, Class<M> moduleClass) {
        Collection<ModuleDescriptor<M>> moduleDescriptors = this.getEnabledModuleDescriptorsByModuleClass(moduleClass);
        return this.getModules(DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new ModuleDescriptorOfClassPredicate<M>(descriptorClass)));
    }

    private <M> Collection<ModuleDescriptor<M>> getEnabledModuleDescriptorsByModuleClass(Class<M> moduleClass) {
        Iterable<ModuleDescriptor<M>> moduleDescriptors = this.getModuleDescriptorsList(this.getEnabledPlugins());
        moduleDescriptors = DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new ModuleOfClassPredicate<M>(moduleClass));
        moduleDescriptors = DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new EnabledModulePredicate(this));
        return CollectionUtil.toList(moduleDescriptors);
    }

    @Override
    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClazz) {
        LinkedList result = new LinkedList();
        for (Plugin plugin : this.plugins.values()) {
            if (!this.isPluginEnabled(plugin.getKey())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Plugin [" + plugin.getKey() + "] is disabled."));
                continue;
            }
            for (ModuleDescriptor<?> module : plugin.getModuleDescriptors()) {
                if (!descriptorClazz.isInstance(module)) continue;
                if (this.isPluginModuleEnabled(module.getCompleteKey())) {
                    ModuleDescriptor<?> moduleDescriptor = module;
                    result.add(moduleDescriptor);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Module [" + module.getCompleteKey() + "] is disabled."));
            }
        }
        return result;
    }

    @Override
    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClazz, boolean verbose) {
        return this.getEnabledModuleDescriptorsByClass(descriptorClazz);
    }

    @Override
    @Deprecated
    public <M> List<ModuleDescriptor<M>> getEnabledModuleDescriptorsByType(String type) throws PluginParseException, IllegalArgumentException {
        Iterable<ModuleDescriptor<M>> moduleDescriptors = this.getModuleDescriptorsList(this.getEnabledPlugins());
        moduleDescriptors = DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new ModuleDescriptorOfTypePredicate(this.moduleDescriptorFactory, type));
        moduleDescriptors = DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new EnabledModulePredicate(this));
        return CollectionUtil.toList(moduleDescriptors);
    }

    private static <M> Iterable<ModuleDescriptor<M>> filterModuleDescriptors(Iterable<ModuleDescriptor<M>> moduleDescriptors, final ModuleDescriptorPredicate<M> moduleDescriptorPredicate) {
        return CollectionUtil.filter(moduleDescriptors, new com.atlassian.plugin.util.collect.Predicate<ModuleDescriptor<M>>(){

            @Override
            public boolean evaluate(ModuleDescriptor<M> input) {
                return moduleDescriptorPredicate.matches(input);
            }
        });
    }

    @Override
    public void enablePlugin(String key) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a plugin key to disable.");
        }
        if (!this.plugins.containsKey(key)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No plugin was found for key '" + key + "'. Not enabling."));
            }
            return;
        }
        Plugin plugin = this.plugins.get(key);
        if (!plugin.getPluginInformation().satisfiesMinJavaVersion()) {
            log.error((Object)("Minimum Java version of '" + plugin.getPluginInformation().getMinJavaVersion() + "' was not satisfied for module '" + key + "'. Not enabling."));
            return;
        }
        this.pluginEnabler.enableRecursively(plugin);
        if (plugin.getPluginState().equals((Object)PluginState.ENABLED)) {
            this.enablePluginState(plugin, this.getStore());
            this.notifyPluginEnabled(plugin);
        }
    }

    protected void enablePluginState(Plugin plugin, PluginPersistentStateStore stateStore) {
        stateStore.save(this.getBuilder().setEnabled(plugin, true).toState());
    }

    protected void notifyPluginEnabled(Plugin plugin) {
        plugin.enable();
        this.classLoader.notifyPluginOrModuleEnabled();
        if (this.enablePluginModules(plugin)) {
            this.pluginEventManager.broadcast(new PluginEnabledEvent(plugin));
        }
    }

    private boolean enablePluginModules(Plugin plugin) {
        boolean success = true;
        for (ModuleDescriptor<?> descriptor : plugin.getModuleDescriptors()) {
            if (!this.isPluginModuleEnabled(descriptor.getCompleteKey())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Plugin module '" + descriptor.getName() + "' is explicitly disabled, so not re-enabling."));
                continue;
            }
            try {
                this.notifyModuleEnabled(descriptor);
            }
            catch (Throwable exception) {
                log.error((Object)("There was an error loading the descriptor '" + descriptor.getName() + "' of plugin '" + plugin.getKey() + "'. Disabling."), exception);
                this.replacePluginWithUnloadablePlugin(plugin, descriptor, exception);
                success = false;
            }
        }
        this.classLoader.notifyPluginOrModuleEnabled();
        return success;
    }

    @Override
    public void disablePlugin(String key) {
        this.disablePluginInternal(key, true);
    }

    @Override
    public void disablePluginWithoutPersisting(String key) {
        this.disablePluginInternal(key, false);
    }

    protected void disablePluginInternal(String key, boolean persistDisabledState) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a plugin key to disable.");
        }
        if (!this.plugins.containsKey(key)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No plugin was found for key '" + key + "'. Not disabling."));
            }
            return;
        }
        Plugin plugin = this.plugins.get(key);
        this.notifyPluginDisabled(plugin);
        if (persistDisabledState) {
            this.disablePluginState(plugin, this.getStore());
        }
    }

    protected void disablePluginState(Plugin plugin, PluginPersistentStateStore stateStore) {
        stateStore.save(this.getBuilder().setEnabled(plugin, false).toState());
    }

    protected void notifyPluginDisabled(Plugin plugin) {
        this.disablePluginModules(plugin);
        plugin.disable();
        this.pluginEventManager.broadcast(new PluginDisabledEvent(plugin));
    }

    private void disablePluginModules(Plugin plugin) {
        ArrayList moduleDescriptors = new ArrayList(plugin.getModuleDescriptors());
        Collections.reverse(moduleDescriptors);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (!this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey())) continue;
            this.publishModuleDisabledEvents(moduleDescriptor);
        }
    }

    @Override
    public void disablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor<?> module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Returned module for key '" + completeKey + "' was null. Not disabling."));
            }
            return;
        }
        this.disablePluginModuleState(module, this.getStore());
        this.notifyModuleDisabled(module);
    }

    protected void disablePluginModuleState(ModuleDescriptor<?> module, PluginPersistentStateStore stateStore) {
        stateStore.save(this.getBuilder().setEnabled(module, false).toState());
    }

    protected void notifyModuleDisabled(ModuleDescriptor<?> module) {
        this.publishModuleDisabledEvents(module);
    }

    private void publishModuleDisabledEvents(ModuleDescriptor<?> module) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disabling " + module.getKey()));
        }
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).disabled();
        }
        this.pluginEventManager.broadcast(new PluginModuleDisabledEvent(module));
    }

    @Override
    public void enablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor<?> module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Returned module for key '" + completeKey + "' was null. Not enabling."));
            }
            return;
        }
        if (!module.satisfiesMinJavaVersion()) {
            log.error((Object)("Minimum Java version of '" + module.getMinJavaVersion() + "' was not satisfied for module '" + completeKey + "'. Not enabling."));
            return;
        }
        this.enablePluginModuleState(module, this.getStore());
        this.notifyModuleEnabled(module);
    }

    protected void enablePluginModuleState(ModuleDescriptor<?> module, PluginPersistentStateStore stateStore) {
        stateStore.save(this.getBuilder().setEnabled(module, true).toState());
    }

    protected void notifyModuleEnabled(ModuleDescriptor<?> module) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enabling " + module.getKey()));
        }
        this.classLoader.notifyPluginOrModuleEnabled();
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).enabled();
        }
        this.pluginEventManager.broadcast(new PluginModuleEnabledEvent(module));
    }

    @Override
    public boolean isPluginModuleEnabled(String completeKey) {
        if (completeKey == null) {
            return false;
        }
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        ModuleDescriptor<?> pluginModule = this.getPluginModule(completeKey);
        return this.isPluginEnabled(key.getPluginKey()) && pluginModule != null && this.getState().isEnabled(pluginModule);
    }

    @Override
    public boolean isPluginEnabled(String key) {
        Plugin plugin = this.plugins.get(key);
        return plugin != null && plugin.getPluginState() == PluginState.ENABLED && this.getState().isEnabled(plugin);
    }

    @Override
    public InputStream getDynamicResourceAsStream(String name) {
        return this.getClassLoader().getResourceAsStream(name);
    }

    @Override
    public Class<?> getDynamicPluginClass(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }

    @Override
    public PluginsClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public InputStream getPluginResourceAsStream(String pluginKey, String resourcePath) {
        Plugin plugin = this.getEnabledPlugin(pluginKey);
        if (plugin == null) {
            log.error((Object)("Attempted to retreive resource " + resourcePath + " for non-existent or inactive plugin " + pluginKey));
            return null;
        }
        return plugin.getResourceAsStream(resourcePath);
    }

    private UnloadablePlugin replacePluginWithUnloadablePlugin(Plugin plugin, ModuleDescriptor<?> descriptor, Throwable throwable) {
        UnloadableModuleDescriptor unloadableDescriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, descriptor, throwable);
        UnloadablePlugin unloadablePlugin = UnloadablePluginFactory.createUnloadablePlugin(plugin, unloadableDescriptor);
        unloadablePlugin.setUninstallable(plugin.isUninstallable());
        unloadablePlugin.setDeletable(plugin.isDeleteable());
        unloadablePlugin.setErrorText(unloadableDescriptor.getErrorText());
        this.plugins.put(plugin.getKey(), unloadablePlugin);
        return unloadablePlugin;
    }

    @Override
    public boolean isSystemPlugin(String key) {
        Plugin plugin = this.getPlugin(key);
        return plugin != null && plugin.isSystemPlugin();
    }

    @Override
    public PluginRestartState getPluginRestartState(String key) {
        return this.getState().getPluginRestartState(key);
    }

    private PluginPersistentState.Builder getBuilder() {
        return PluginPersistentState.Builder.create(this.getStore().load());
    }

    @Deprecated
    public void setDescriptorParserFactory(DescriptorParserFactory descriptorParserFactory) {
    }
}

