/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.impl.StaticPlugin;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePluginLoader
implements PluginLoader {
    protected Collection<Plugin> plugins;
    private final String resource;
    private final URL url;
    private final DescriptorParserFactory descriptorParserFactory = new XmlDescriptorParserFactory();
    private static final Log log = LogFactory.getLog(SinglePluginLoader.class);
    private final AtomicReference<InputStream> inputStreamRef;

    public SinglePluginLoader(String resource) {
        this.resource = Assertions.notNull("resource", resource);
        this.url = null;
        this.inputStreamRef = new AtomicReference<Object>(null);
    }

    public SinglePluginLoader(URL url) {
        this.url = Assertions.notNull("url", url);
        this.resource = null;
        this.inputStreamRef = new AtomicReference<Object>(null);
    }

    public SinglePluginLoader(InputStream is) {
        this.inputStreamRef = new AtomicReference<InputStream>(Assertions.notNull("inputStream", is));
        this.resource = null;
        this.url = null;
    }

    @Override
    public Collection<Plugin> loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        if (this.plugins == null) {
            Plugin plugin;
            try {
                plugin = this.loadPlugin(moduleDescriptorFactory);
            }
            catch (RuntimeException ex) {
                String id = this.getIdentifier();
                log.error((Object)("Error loading plugin or descriptor: " + id), (Throwable)ex);
                plugin = new UnloadablePlugin(id + ": " + ex);
                plugin.setKey(id);
            }
            this.plugins = Collections.singleton(plugin);
        }
        return this.plugins;
    }

    @Override
    public boolean supportsRemoval() {
        return false;
    }

    @Override
    public boolean supportsAddition() {
        return false;
    }

    @Override
    public Collection<Plugin> addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        throw new UnsupportedOperationException("This PluginLoader does not support addition.");
    }

    @Override
    public void removePlugin(Plugin plugin) throws PluginException {
        throw new PluginException("This PluginLoader does not support removal.");
    }

    protected Plugin loadPlugin(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Plugin plugin;
        InputStream source = this.getSource();
        if (source == null) {
            throw new PluginParseException("Invalid resource or inputstream specified to load plugins from.");
        }
        try {
            DescriptorParser parser = this.descriptorParserFactory.getInstance(source, null);
            plugin = parser.configurePlugin(moduleDescriptorFactory, this.getNewPlugin());
            if (plugin.getPluginsVersion() == 2) {
                UnloadablePlugin unloadablePlugin = UnloadablePluginFactory.createUnloadablePlugin(plugin);
                StringBuilder errorText = new StringBuilder("OSGi plugins cannot be deployed via the classpath, which is usually WEB-INF/lib.");
                if (this.resource != null) {
                    errorText.append("\n Resource is: ").append(this.resource);
                }
                if (this.url != null) {
                    errorText.append("\n URL is: ").append(this.url);
                }
                unloadablePlugin.setErrorText(errorText.toString());
                plugin = unloadablePlugin;
            } else if (parser.isSystemPlugin()) {
                plugin.setSystemPlugin(true);
            }
        }
        catch (PluginParseException e) {
            throw new PluginParseException("Unable to load plugin resource: " + this.resource + " - " + e.getMessage(), e);
        }
        return plugin;
    }

    private String getIdentifier() {
        if (this.resource != null) {
            return this.resource;
        }
        if (this.url != null) {
            return this.url.getPath();
        }
        return this.inputStreamRef.toString();
    }

    protected StaticPlugin getNewPlugin() {
        return new StaticPlugin();
    }

    protected InputStream getSource() {
        if (this.resource != null) {
            return ClassLoaderUtils.getResourceAsStream(this.resource, this.getClass());
        }
        if (this.url != null) {
            try {
                return this.url.openConnection().getInputStream();
            }
            catch (IOException e) {
                throw new PluginParseException(e);
            }
        }
        InputStream inputStream = this.inputStreamRef.getAndSet(null);
        if (inputStream != null) {
            return inputStream;
        }
        throw new IllegalStateException("No defined method for getting an input stream.");
    }
}

