package com.atlassian.plugin.util.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/**
 * @deprecated since 2.12.3. Use Google Guava instead.
 */
public class CollectionUtil
{

    public static <T> void foreach(final Iterator<T> iterator, final Consumer<T> sink)
    {
        while (iterator.hasNext())
        {
            sink.consume(iterator.next());
        }
    }

    public static <T> void foreach(final Iterable<T> iterable, final Consumer<T> sink)
    {
        if (iterable != null)
        {
            foreach(iterable.iterator(), sink);
        }
    }

    /**
     * @return the given iterable converted to a List.
     * @deprecated since 2.12.3. Use {@link com.google.common.collect.ImmutableList#copyOf(Iterable)} instead.
     */
    @Deprecated
    public static <T> List<T> toList(final Iterable<T> iterable)
    {
        return toList(iterable.iterator());
    }

    /**
     * @return the given iterator converted to a List.
     * @deprecated since 2.12.3. Use {@link com.google.common.collect.ImmutableList#copyOf(Iterator)} instead.
     */
    @Deprecated
    public static <T> List<T> toList(final Iterator<T> iterator)
    {
        final List<T> result = new ArrayList<T>();
        foreach(iterator, new Consumer<T>()
        {
            public void consume(final T element)
            {
                if (element != null)
                {
                    result.add(element);
                }
            }
        });
        return result;
    }

    /**
     * @deprecated since 2.12.3. Use {@link com.google.common.collect.Lists#transform(java.util.List, com.google.common.base.Function)} instead.
     */
    @Deprecated
    public static <T, R> List<R> transform(final Iterator<T> iterator, final Function<T, R> transformer)
    {
        return toList(transformIterator(iterator, transformer));
    }

    /**
     * @deprecated since 2.12.3. Use {@link com.google.common.collect.Iterables#transform(Iterable, com.google.common.base.Function)} instead.
     */
    @Deprecated
    public static <T, R> List<R> transform(final Iterable<T> iterable, final Function<T, R> transformer)
    {
        if (iterable == null)
        {
            return Collections.emptyList();
        }
        return transform(iterable.iterator(), transformer);
    }

    /**
     * @deprecated since 2.12.3. Use {@link com.google.common.collect.Iterators#transform(java.util.Iterator, com.google.common.base.Function)} instead.
     */
    @Deprecated
    public static <T, R> Iterator<R> transformIterator(final Iterator<T> iterator, final Function<T, R> transformer)
    {
        return new TransformingIterator<T, R>(iterator, transformer);
    }

    /**
     * Create a filtered {@link Iterator}.
     * @deprecated since 2.12.3. Use {@link com.google.common.collect.Iterators#filter(java.util.Iterator, com.google.common.base.Predicate)} instead.
     */
    @Deprecated
    public static <T> Iterator<T> filter(final Iterator<T> iterator, final Predicate<T> predicate)
    {
        return new FilteredIterator<T>(iterator, predicate);
    }

    /**
     * Create a filtered {@link Iterator}.
     * @deprecated since 2.12.3. Use {@link com.google.common.collect.Iterables#filter(java.lang.Iterable, com.google.common.base.Predicate)} instead.
     */
    public static <T> Iterable<T> filter(final Iterable<T> iterable, final Predicate<T> predicate)
    {
        return new FilteredIterable<T>(iterable, predicate);
    }

    static class FilteredIterable<T> implements Iterable<T>
    {
        private final Iterable<T> delegate;
        private final Predicate<T> predicate;

        FilteredIterable(final Iterable<T> delegate, final Predicate<T> predicate)
        {
            this.delegate = delegate;
            this.predicate = predicate;
        }

        public Iterator<T> iterator()
        {
            return new FilteredIterator<T>(delegate.iterator(), predicate);
        }

        @Override
        public String toString()
        {
            return toList(this).toString();
        }
    }

    public static <T> List<T> sort(final Collection<T> collection, final Comparator<T> comparator)
    {
        final List<T> sorted = new ArrayList<T>(collection);
        if (sorted.size() > 1)
        {
            Collections.sort(sorted, comparator);
        }
        return sorted;
    }
}
