/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.manager.ForwardingPluginAccessor;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public final class EnabledModuleCachingPluginAccessor
extends ForwardingPluginAccessor
implements PluginAccessor {
    private final PluginEventManager pluginEventManager;
    private final ConcurrentMap<Class<ModuleDescriptor<Object>>, PluginModuleTracker<Object, ModuleDescriptor<Object>>> cache = new MapMaker().weakKeys().weakValues().makeComputingMap((Function)new PluginModuleTrackerFactory());

    public EnabledModuleCachingPluginAccessor(PluginAccessor delegate, PluginEventManager pluginEventManager) {
        super(delegate);
        this.pluginEventManager = (PluginEventManager)Preconditions.checkNotNull((Object)pluginEventManager);
        this.pluginEventManager.register(this);
    }

    @Override
    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClazz) {
        return ImmutableList.copyOf(this.descriptors(descriptorClazz));
    }

    @PluginEventListener
    public void onPluginDisable(PluginDisabledEvent event) {
        this.cache.clear();
    }

    <D> Iterable<D> descriptors(Class<D> moduleDescriptorClass) {
        Iterable descriptors = ((PluginModuleTracker)this.cache.get(moduleDescriptorClass)).getModuleDescriptors();
        return descriptors;
    }

    final class PluginModuleTrackerFactory
    implements Function<Class<ModuleDescriptor<Object>>, PluginModuleTracker<Object, ModuleDescriptor<Object>>> {
        PluginModuleTrackerFactory() {
        }

        public PluginModuleTracker<Object, ModuleDescriptor<Object>> apply(Class<ModuleDescriptor<Object>> moduleDescriptorClass) {
            return DefaultPluginModuleTracker.create(EnabledModuleCachingPluginAccessor.this.delegate, EnabledModuleCachingPluginAccessor.this.pluginEventManager, moduleDescriptorClass);
        }
    }
}

