/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.factories;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.XmlPluginArtifact;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.XmlDynamicPlugin;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.dom4j.DocumentException;

public class XmlDynamicPluginFactory
implements PluginFactory {
    private final DescriptorParserFactory descriptorParserFactory = new XmlDescriptorParserFactory();
    private final Set<String> applicationKeys;

    @Deprecated
    public XmlDynamicPluginFactory() {
        this(Collections.emptySet());
    }

    public XmlDynamicPluginFactory(String applicationKey) {
        this(new HashSet<String>(Arrays.asList(applicationKey)));
    }

    public XmlDynamicPluginFactory(Set<String> applicationKeys) {
        Validate.notNull(applicationKeys, (String)"applicationKeys");
        this.applicationKeys = applicationKeys;
    }

    @Override
    @Deprecated
    public Plugin create(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        return this.create(new XmlPluginArtifact(deploymentUnit.getPath()), moduleDescriptorFactory);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Plugin plugin;
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact must not be null");
        Validate.notNull((Object)moduleDescriptorFactory, (String)"The module descriptor factory must not be null");
        FileInputStream pluginDescriptor = null;
        try {
            pluginDescriptor = new FileInputStream(pluginArtifact.toFile());
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor, this.applicationKeys.toArray(new String[this.applicationKeys.size()]));
            plugin = parser.configurePlugin(moduleDescriptorFactory, new XmlDynamicPlugin(pluginArtifact));
        }
        catch (RuntimeException e) {
            try {
                throw new PluginParseException(e);
                catch (IOException e2) {
                    throw new PluginParseException();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pluginDescriptor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact must not be null");
        InputStream descriptorStream = null;
        try {
            descriptorStream = pluginArtifact.getInputStream();
            if (descriptorStream == null) {
                String string = null;
                return string;
            }
            DescriptorParser descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream, this.applicationKeys.toArray(new String[this.applicationKeys.size()]));
            String string = descriptorParser.getKey();
            return string;
        }
        catch (PluginParseException ex) {
            if (!(ex.getCause() instanceof DocumentException)) {
                throw ex;
            }
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)descriptorStream);
        }
    }
}

