/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util.collect;

import com.atlassian.plugin.util.collect.Consumer;
import com.atlassian.plugin.util.collect.FilteredIterator;
import com.atlassian.plugin.util.collect.Function;
import com.atlassian.plugin.util.collect.Predicate;
import com.atlassian.plugin.util.collect.TransformingIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CollectionUtil {
    public static <T> void foreach(Iterator<T> iterator, Consumer<T> sink) {
        while (iterator.hasNext()) {
            sink.consume(iterator.next());
        }
    }

    public static <T> void foreach(Iterable<T> iterable, Consumer<T> sink) {
        if (iterable != null) {
            CollectionUtil.foreach(iterable.iterator(), sink);
        }
    }

    @Deprecated
    public static <T> List<T> toList(Iterable<T> iterable) {
        return CollectionUtil.toList(iterable.iterator());
    }

    @Deprecated
    public static <T> List<T> toList(Iterator<T> iterator) {
        final ArrayList result = new ArrayList();
        CollectionUtil.foreach(iterator, new Consumer<T>(){

            @Override
            public void consume(T element) {
                if (element != null) {
                    result.add(element);
                }
            }
        });
        return result;
    }

    @Deprecated
    public static <T, R> List<R> transform(Iterator<T> iterator, Function<T, R> transformer) {
        return CollectionUtil.toList(CollectionUtil.transformIterator(iterator, transformer));
    }

    @Deprecated
    public static <T, R> List<R> transform(Iterable<T> iterable, Function<T, R> transformer) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return CollectionUtil.transform(iterable.iterator(), transformer);
    }

    @Deprecated
    public static <T, R> Iterator<R> transformIterator(Iterator<T> iterator, Function<T, R> transformer) {
        return new TransformingIterator<T, R>(iterator, transformer);
    }

    @Deprecated
    public static <T> Iterator<T> filter(Iterator<T> iterator, Predicate<T> predicate) {
        return new FilteredIterator<T>(iterator, predicate);
    }

    public static <T> Iterable<T> filter(Iterable<T> iterable, Predicate<T> predicate) {
        return new FilteredIterable<T>(iterable, predicate);
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> sorted = new ArrayList<T>(collection);
        if (sorted.size() > 1) {
            Collections.sort(sorted, comparator);
        }
        return sorted;
    }

    static class FilteredIterable<T>
    implements Iterable<T> {
        private final Iterable<T> delegate;
        private final Predicate<T> predicate;

        FilteredIterable(Iterable<T> delegate, Predicate<T> predicate) {
            this.delegate = delegate;
            this.predicate = predicate;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilteredIterator<T>(this.delegate.iterator(), this.predicate);
        }

        public String toString() {
            return CollectionUtil.toList(this).toString();
        }
    }
}

