/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginParseException;
import java.util.Collection;

public class ChainModuleDescriptorFactory
implements ModuleDescriptorFactory {
    private final ModuleDescriptorFactory[] factories;

    public ChainModuleDescriptorFactory(ModuleDescriptorFactory ... factories) {
        this.factories = factories;
    }

    public ChainModuleDescriptorFactory(Collection<? extends ModuleDescriptorFactory> factories) {
        this(factories.toArray(new ModuleDescriptorFactory[factories.size()]));
    }

    @Override
    public ModuleDescriptor<?> getModuleDescriptor(String type) throws PluginParseException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        for (ModuleDescriptorFactory factory : this.factories) {
            if (!factory.hasModuleDescriptor(type)) continue;
            return factory.getModuleDescriptor(type);
        }
        return null;
    }

    @Override
    public boolean hasModuleDescriptor(String type) {
        for (ModuleDescriptorFactory factory : this.factories) {
            if (!factory.hasModuleDescriptor(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<? extends ModuleDescriptor> getModuleDescriptorClass(String type) {
        for (ModuleDescriptorFactory factory : this.factories) {
            Class<? extends ModuleDescriptor> descriptorClass = factory.getModuleDescriptorClass(type);
            if (descriptorClass == null) continue;
            return descriptorClass;
        }
        return null;
    }
}

