/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util;

import com.atlassian.plugin.util.zip.UrlUnzipper;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static void conditionallyExtractZipFile(URL zipUrl, File destDir) {
        try {
            UrlUnzipper unzipper = new UrlUnzipper(zipUrl, destDir);
            unzipper.conditionalUnzip();
        }
        catch (IOException e) {
            log.error("Found " + zipUrl + ", but failed to read file", (Throwable)e);
        }
    }

    public static File toFile(URL url) {
        if (!"file".equalsIgnoreCase(url.getProtocol())) {
            return null;
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            log.error("Could not convert file:// url to a File", (Throwable)e);
            return null;
        }
    }

    public static void deleteDir(File directory) {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            log.error("Unable to delete directory: " + directory.getAbsolutePath(), (Throwable)e);
        }
    }
}

