/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.manager.PluginPersistentState;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public final class DefaultPluginPersistentState
implements Serializable,
PluginPersistentState {
    private final Map<String, Boolean> map;

    @Deprecated
    public DefaultPluginPersistentState() {
        this.map = Collections.emptyMap();
    }

    @Deprecated
    public DefaultPluginPersistentState(Map<String, Boolean> map) {
        this.map = Collections.unmodifiableMap(new HashMap<String, Boolean>(map));
    }

    DefaultPluginPersistentState(Map<String, Boolean> map, boolean ignore) {
        this.map = Collections.unmodifiableMap(new HashMap<String, Boolean>(map));
    }

    @Deprecated
    public DefaultPluginPersistentState(PluginPersistentState state) {
        this(state.getMap());
    }

    @Override
    public Map<String, Boolean> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public boolean isEnabled(Plugin plugin) {
        Boolean bool = this.map.get(plugin.getKey());
        return bool == null ? plugin.isEnabledByDefault() : bool.booleanValue();
    }

    @Override
    public boolean isEnabled(ModuleDescriptor<?> pluginModule) {
        if (pluginModule == null) {
            return false;
        }
        Boolean bool = this.map.get(pluginModule.getCompleteKey());
        return bool == null ? pluginModule.isEnabledByDefault() : bool.booleanValue();
    }

    @Override
    public Map<String, Boolean> getPluginStateMap(Plugin plugin) {
        HashMap<String, Boolean> state = new HashMap<String, Boolean>(this.getMap());
        CollectionUtils.filter(state.keySet(), (Predicate)new StringStartsWith(plugin.getKey()));
        return state;
    }

    @Override
    public PluginRestartState getPluginRestartState(String pluginKey) {
        for (PluginRestartState state : PluginRestartState.values()) {
            if (!this.map.containsKey(PluginPersistentState.Util.buildStateKey(pluginKey, state))) continue;
            return state;
        }
        return PluginRestartState.NONE;
    }

    private static class StringStartsWith
    implements Predicate {
        private final String prefix;

        public StringStartsWith(String keyPrefix) {
            this.prefix = keyPrefix;
        }

        public boolean evaluate(Object object) {
            String str = (String)object;
            return str.startsWith(this.prefix);
        }
    }
}

