/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.ModuleDescriptors;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.loaders.LoaderUtils;
import com.atlassian.plugin.module.LegacyModuleFactory;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.module.PrefixDelegatingModuleFactory;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.util.ClassUtils;
import com.atlassian.plugin.util.JavaVersionUtils;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.util.concurrent.NotNull;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModuleDescriptor<T>
implements ModuleDescriptor<T>,
StateAware {
    protected Plugin plugin;
    String key;
    String name;
    protected String moduleClassName;
    protected Class<T> moduleClass;
    String description;
    boolean enabledByDefault = true;
    boolean systemModule = false;
    @Deprecated
    protected boolean singleton = true;
    Map<String, String> params;
    protected Resources resources = Resources.EMPTY_RESOURCES;
    private Float minJavaVersion;
    private String i18nNameKey;
    private String descriptionKey;
    private String completeKey;
    boolean enabled = false;
    protected final ModuleFactory moduleFactory;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractModuleDescriptor(ModuleFactory moduleFactory) {
        Validate.notNull((Object)moduleFactory, (String)"Module creator factory cannot be null");
        this.moduleFactory = moduleFactory;
    }

    @Deprecated
    public AbstractModuleDescriptor() {
        this(ModuleFactory.LEGACY_MODULE_FACTORY);
    }

    @Override
    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        this.validate(element);
        this.plugin = Assertions.notNull("plugin", plugin);
        this.key = element.attributeValue("key");
        this.name = element.attributeValue("name");
        this.i18nNameKey = element.attributeValue("i18n-name-key");
        this.completeKey = this.buildCompleteKey(plugin, this.key);
        this.description = element.elementTextTrim("description");
        this.moduleClassName = element.attributeValue("class");
        Element descriptionElement = element.element("description");
        this.descriptionKey = descriptionElement != null ? descriptionElement.attributeValue("key") : null;
        this.params = LoaderUtils.getParams(element);
        if ("disabled".equalsIgnoreCase(element.attributeValue("state"))) {
            this.enabledByDefault = false;
        }
        if ("true".equalsIgnoreCase(element.attributeValue("system"))) {
            this.systemModule = true;
        }
        if (element.element("java-version") != null) {
            this.minJavaVersion = Float.valueOf(element.element("java-version").attributeValue("min"));
        }
        this.singleton = "false".equalsIgnoreCase(element.attributeValue("singleton")) ? false : ("true".equalsIgnoreCase(element.attributeValue("singleton")) ? true : this.isSingletonByDefault());
        this.resources = Resources.fromXml(element);
    }

    private void validate(Element element) {
        Assertions.notNull("element", element);
        ValidationPattern pattern = ValidationPattern.createPattern();
        this.provideValidationRules(pattern);
        pattern.evaluate((Node)element);
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        pattern.rule(ValidationPattern.test("@key").withError("The key is required"));
    }

    @Deprecated
    protected void loadClass(Plugin plugin, Element element) throws PluginParseException {
        this.loadClass(plugin, element.attributeValue("class"));
    }

    protected void loadClass(Plugin plugin, String clazz) throws PluginParseException {
        if (this.moduleClassName != null) {
            if (this.moduleFactory instanceof LegacyModuleFactory) {
                this.moduleClass = ((LegacyModuleFactory)this.moduleFactory).getModuleClass(this.moduleClassName, this);
            } else if (this.moduleFactory instanceof PrefixDelegatingModuleFactory) {
                this.moduleClass = ((PrefixDelegatingModuleFactory)this.moduleFactory).guessModuleClass(this.moduleClassName, this);
            }
        } else {
            this.moduleClass = Void.class;
        }
        if (this.moduleClass == null) {
            try {
                Class<?> moduleTypeClass = null;
                try {
                    moduleTypeClass = ClassUtils.getTypeArguments(AbstractModuleDescriptor.class, this.getClass()).get(0);
                }
                catch (RuntimeException ex) {
                    this.log.debug("Unable to get generic type, usually due to Class.forName() problems", (Throwable)ex);
                    moduleTypeClass = this.getModuleReturnClass();
                }
                this.moduleClass = moduleTypeClass;
            }
            catch (ClassCastException ex) {
                throw new IllegalStateException("The module class must be defined in a concrete instance of ModuleDescriptor and not as another generic type.");
            }
            if (this.moduleClass == null) {
                throw new IllegalStateException("The module class cannot be determined, likely because it needs a concrete module type defined in the generic type it passes to AbstractModuleDescriptor");
            }
        }
    }

    Class<?> getModuleReturnClass() {
        try {
            return this.getClass().getMethod("getModule", new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("The getModule() method is missing (!) on " + this.getClass());
        }
    }

    private String buildCompleteKey(Plugin plugin, String moduleKey) {
        if (plugin == null) {
            return null;
        }
        StringBuffer completeKeyBuffer = new StringBuffer(32);
        completeKeyBuffer.append(plugin.getKey()).append(":").append(moduleKey);
        return completeKeyBuffer.toString();
    }

    @Override
    public void destroy(Plugin plugin) {
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.enabledByDefault && this.satisfiesMinJavaVersion();
    }

    @Override
    public boolean isSystemModule() {
        return this.systemModule;
    }

    @Deprecated
    public boolean isSingleton() {
        return this.singleton;
    }

    @Deprecated
    protected boolean isSingletonByDefault() {
        return true;
    }

    protected final void assertModuleClassImplements(Class<T> requiredModuleClazz) throws PluginParseException {
        if (!this.enabled) {
            throw new PluginParseException("Plugin module " + this.getKey() + " not enabled");
        }
        if (!requiredModuleClazz.isAssignableFrom(this.getModuleClass())) {
            throw new PluginParseException("Given module class: " + this.getModuleClass().getName() + " does not implement " + requiredModuleClazz.getName());
        }
    }

    @Override
    public String getCompleteKey() {
        return this.completeKey;
    }

    @Override
    public String getPluginKey() {
        return this.getPlugin().getKey();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getModuleClass() {
        return this.moduleClass;
    }

    @Override
    public abstract T getModule();

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getI18nNameKey() {
        return this.i18nNameKey;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptors() {
        return this.resources.getResourceDescriptors();
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptors(String type) {
        return this.resources.getResourceDescriptors(type);
    }

    @Override
    public ResourceLocation getResourceLocation(String type, String name) {
        return this.resources.getResourceLocation(type, name);
    }

    @Override
    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.resources.getResourceDescriptor(type, name);
    }

    @Override
    public Float getMinJavaVersion() {
        return this.minJavaVersion;
    }

    @Override
    public boolean satisfiesMinJavaVersion() {
        if (this.minJavaVersion != null) {
            return JavaVersionUtils.satisfiesMinVersion(this.minJavaVersion.floatValue());
        }
        return true;
    }

    public void setPlugin(Plugin plugin) {
        this.completeKey = this.buildCompleteKey(plugin, this.key);
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean equals(Object obj) {
        return new ModuleDescriptors.EqualsBuilder().descriptor(this).isEqualTo(obj);
    }

    @Override
    public int hashCode() {
        return new ModuleDescriptors.HashCodeBuilder().descriptor(this).toHashCode();
    }

    public String toString() {
        return this.getCompleteKey() + " (" + this.getDescription() + ")";
    }

    @Override
    public void enabled() {
        this.loadClass(this.plugin, this.moduleClassName);
        this.enabled = true;
    }

    @Override
    public void disabled() {
        this.enabled = false;
        this.moduleClass = null;
    }
}

