/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathPluginLoader
implements PluginLoader {
    private static Logger log = LoggerFactory.getLogger(ClassPathPluginLoader.class);
    private final String fileNameToLoad;
    private List<Plugin> plugins;

    public ClassPathPluginLoader() {
        this("atlassian-plugin.xml");
    }

    public ClassPathPluginLoader(String fileNameToLoad) {
        this.fileNameToLoad = fileNameToLoad;
    }

    private void loadClassPathPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Enumeration<URL> pluginDescriptorFiles;
        URL url = null;
        this.plugins = new ArrayList<Plugin>();
        try {
            pluginDescriptorFiles = ClassLoaderUtils.getResources(this.fileNameToLoad, this.getClass());
        }
        catch (IOException e) {
            log.error("Could not load classpath plugins: " + e, (Throwable)e);
            return;
        }
        while (pluginDescriptorFiles.hasMoreElements()) {
            url = pluginDescriptorFiles.nextElement();
            this.plugins.addAll(new SinglePluginLoader(url).loadAllPlugins(moduleDescriptorFactory));
        }
    }

    @Override
    public Collection<Plugin> loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        if (this.plugins == null) {
            this.loadClassPathPlugins(moduleDescriptorFactory);
        }
        return this.plugins;
    }

    @Override
    public boolean supportsRemoval() {
        return false;
    }

    @Override
    public boolean supportsAddition() {
        return false;
    }

    @Override
    public Collection<Plugin> addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        throw new UnsupportedOperationException("This PluginLoader does not support addition.");
    }

    @Override
    public void removePlugin(Plugin plugin) throws PluginException {
        throw new PluginException("This PluginLoader does not support removal.");
    }
}

