/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.Scanner;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectoryScanner
implements Scanner {
    private static Log log = LogFactory.getLog(DirectoryScanner.class);
    private final File pluginsDirectory;
    private Map<String, DeploymentUnit> scannedDeploymentUnits = new HashMap<String, DeploymentUnit>();

    public DirectoryScanner(File pluginsDirectory) {
        Validate.notNull((Object)pluginsDirectory, (String)"Plugin scanner directory must not be null");
        this.pluginsDirectory = pluginsDirectory;
    }

    private DeploymentUnit createAndStoreDeploymentUnit(File file) throws MalformedURLException {
        if (this.isScanned(file)) {
            return null;
        }
        DeploymentUnit unit = new DeploymentUnit(file);
        this.scannedDeploymentUnits.put(file.getAbsolutePath(), unit);
        return unit;
    }

    public DeploymentUnit locateDeploymentUnit(File file) {
        return this.scannedDeploymentUnits.get(file.getAbsolutePath());
    }

    private boolean isScanned(File file) {
        return this.locateDeploymentUnit(file) != null;
    }

    public void clear(File file) {
        this.scannedDeploymentUnits.remove(file.getAbsolutePath());
    }

    @Override
    public Collection<DeploymentUnit> scan() {
        ArrayList<File> removedFiles = new ArrayList<File>();
        for (DeploymentUnit unit : this.scannedDeploymentUnits.values()) {
            if (unit.getPath().exists() && unit.getPath().canRead()) continue;
            removedFiles.add(unit.getPath());
        }
        this.clear(removedFiles);
        ArrayList<DeploymentUnit> result = new ArrayList<DeploymentUnit>();
        File[] files = this.pluginsDirectory.listFiles();
        if (files == null) {
            log.error((Object)("listFiles returned null for directory " + this.pluginsDirectory.getAbsolutePath()));
        } else {
            for (File file : files) {
                try {
                    DeploymentUnit unit;
                    if (this.isScanned(file) && this.isModified(file)) {
                        this.clear(file);
                        unit = this.createAndStoreDeploymentUnit(file);
                        if (unit == null) continue;
                        result.add(unit);
                        continue;
                    }
                    if (this.isScanned(file) || (unit = this.createAndStoreDeploymentUnit(file)) == null) continue;
                    result.add(unit);
                }
                catch (MalformedURLException e) {
                    log.error((Object)("Error deploying plugin " + file.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return result;
    }

    private boolean isModified(File file) {
        DeploymentUnit unit = this.locateDeploymentUnit(file);
        return file.lastModified() > unit.lastModified();
    }

    private void clear(List<File> toUndeploy) {
        for (File aToUndeploy : toUndeploy) {
            this.clear(aToUndeploy);
        }
    }

    @Override
    public Collection<DeploymentUnit> getDeploymentUnits() {
        return Collections.unmodifiableCollection(this.scannedDeploymentUnits.values());
    }

    @Override
    public void reset() {
        this.scannedDeploymentUnits.clear();
    }

    @Override
    public void remove(DeploymentUnit unit) throws PluginException {
        if (!unit.getPath().delete()) {
            throw new PluginException("Unable to delete file: " + unit.getPath());
        }
        this.clear(unit.getPath());
    }
}

