/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.DynamicPlugin;
import com.atlassian.plugin.loaders.DirectoryPluginLoader;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.util.FileUtils;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundledPluginLoader
extends DirectoryPluginLoader {
    private static final Log log = LogFactory.getLog(BundledPluginLoader.class);

    public BundledPluginLoader(URL zipUrl, File pluginPath, List<PluginFactory> pluginFactories, PluginEventManager eventManager) {
        super(pluginPath, pluginFactories, eventManager);
        if (zipUrl == null) {
            throw new IllegalArgumentException("Bundled zip url cannot be null");
        }
        FileUtils.conditionallyExtractZipFile(zipUrl, pluginPath);
    }

    @Override
    protected Plugin deployPluginFromUnit(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Plugin plugin = super.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
        if (plugin instanceof DynamicPlugin) {
            DynamicPlugin dplugin = (DynamicPlugin)plugin;
            dplugin.setDeletable(false);
            dplugin.setBundled(true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deployed bundled plugin: " + plugin.getName()));
        }
        return plugin;
    }
}

