/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.factories;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.classloader.PluginClassLoader;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.DefaultDynamicPlugin;
import com.atlassian.plugin.impl.DynamicPlugin;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class LegacyDynamicPluginFactory
implements PluginFactory {
    private DescriptorParserFactory descriptorParserFactory;
    private String pluginDescriptorFileName;
    private final File tempDirectory;

    public LegacyDynamicPluginFactory(String pluginDescriptorFileName) {
        this(pluginDescriptorFileName, new File(System.getProperty("java.io.tmpdir")));
    }

    public LegacyDynamicPluginFactory(String pluginDescriptorFileName, File tempDirectory) {
        this.tempDirectory = tempDirectory;
        Validate.notEmpty((String)pluginDescriptorFileName, (String)"Plugin descriptor name cannot be null or blank");
        this.descriptorParserFactory = new XmlDescriptorParserFactory();
        this.pluginDescriptorFileName = pluginDescriptorFileName;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Plugin create(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Validate.notNull((Object)deploymentUnit, (String)"The deployment unit must not be null");
        Validate.notNull((Object)moduleDescriptorFactory, (String)"The module descriptor factory must not be null");
        Plugin plugin = null;
        InputStream pluginDescriptor = null;
        PluginClassLoader loader = null;
        try {
            loader = new PluginClassLoader(deploymentUnit.getPath(), Thread.currentThread().getContextClassLoader(), this.tempDirectory);
            URL pluginDescriptorUrl = loader.getLocalResource(this.pluginDescriptorFileName);
            if (pluginDescriptorUrl == null) {
                throw new PluginParseException("No descriptor found in classloader for : " + deploymentUnit);
            }
            pluginDescriptor = pluginDescriptorUrl.openStream();
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor);
            plugin = parser.configurePlugin(moduleDescriptorFactory, this.createPlugin(deploymentUnit, loader));
        }
        catch (PluginParseException e) {
            try {
                if (loader == null) throw e;
                loader.close();
                throw e;
                catch (RuntimeException e2) {
                    if (loader == null) throw new PluginParseException(e2);
                    loader.close();
                    throw new PluginParseException(e2);
                }
                catch (Error e3) {
                    if (loader == null) throw e3;
                    loader.close();
                    throw e3;
                }
                catch (IOException e4) {
                    if (loader == null) throw new PluginParseException(e4);
                    loader.close();
                    throw new PluginParseException(e4);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pluginDescriptor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }

    protected DynamicPlugin createPlugin(DeploymentUnit deploymentUnit, PluginClassLoader loader) {
        return new DefaultDynamicPlugin(deploymentUnit, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact must not be null");
        String pluginKey = null;
        InputStream descriptorStream = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
        if (descriptorStream != null) {
            try {
                DescriptorParser descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream);
                if (descriptorParser.getPluginsVersion() <= 1) {
                    pluginKey = descriptorParser.getKey();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)descriptorStream);
            }
        }
        return pluginKey;
    }
}

