/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.loaders.LoaderUtils;
import com.atlassian.plugin.util.JavaVersionUtils;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleDescriptor<T>
implements ModuleDescriptor<T>,
StateAware {
    protected Plugin plugin;
    String key;
    String name;
    String moduleClassName;
    Class moduleClass;
    String description;
    boolean enabledByDefault = true;
    boolean systemModule = false;
    protected boolean singleton = true;
    Map<String, String> params;
    protected Resources resources = Resources.EMPTY_RESOURCES;
    private Float minJavaVersion;
    private String i18nNameKey;
    private String descriptionKey;
    private String completeKey;
    boolean enabled = false;

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        this.plugin = plugin;
        this.key = element.attributeValue("key");
        this.name = element.attributeValue("name");
        this.i18nNameKey = element.attributeValue("i18n-name-key");
        this.completeKey = this.buildCompleteKey(plugin, this.key);
        this.description = element.elementTextTrim("description");
        this.moduleClassName = element.attributeValue("class");
        Element descriptionElement = element.element("description");
        this.descriptionKey = descriptionElement != null ? descriptionElement.attributeValue("key") : null;
        this.params = LoaderUtils.getParams(element);
        if ("disabled".equalsIgnoreCase(element.attributeValue("state"))) {
            this.enabledByDefault = false;
        }
        if ("true".equalsIgnoreCase(element.attributeValue("system"))) {
            this.systemModule = true;
        }
        if (element.element("java-version") != null) {
            this.minJavaVersion = Float.valueOf(element.element("java-version").attributeValue("min"));
        }
        this.singleton = "false".equalsIgnoreCase(element.attributeValue("singleton")) ? false : ("true".equalsIgnoreCase(element.attributeValue("singleton")) ? true : this.isSingletonByDefault());
        this.resources = Resources.fromXml(element);
    }

    protected void loadClass(Plugin plugin, Element element) throws PluginParseException {
        this.loadClass(plugin, element.attributeValue("class"));
    }

    protected void loadClass(Plugin plugin, String clazz) throws PluginParseException {
        block8: {
            try {
                if (clazz == null) break block8;
                this.moduleClass = plugin.loadClass(clazz, this.getClass());
                try {
                    Constructor noargConstructor = this.moduleClass.getConstructor(new Class[0]);
                    if (noargConstructor != null) {
                        this.moduleClass.newInstance();
                    }
                }
                catch (NoSuchMethodException e) {}
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Could not load class: " + clazz, e);
            }
            catch (NoClassDefFoundError e) {
                throw new PluginParseException("Error retrieving dependency of class: " + clazz + ". Missing class: " + e.getMessage());
            }
            catch (UnsupportedClassVersionError e) {
                throw new PluginParseException("Class version is incompatible with current JVM: " + clazz, e);
            }
            catch (Throwable t) {
                throw new PluginParseException(t);
            }
        }
    }

    private String buildCompleteKey(Plugin plugin, String moduleKey) {
        if (plugin == null) {
            return null;
        }
        StringBuffer completeKeyBuffer = new StringBuffer(32);
        completeKeyBuffer.append(plugin.getKey()).append(":").append(moduleKey);
        return completeKeyBuffer.toString();
    }

    @Override
    public void destroy(Plugin plugin) {
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.enabledByDefault && this.satisfiesMinJavaVersion();
    }

    @Override
    public boolean isSystemModule() {
        return this.systemModule;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    protected boolean isSingletonByDefault() {
        return true;
    }

    protected final void assertModuleClassImplements(Class requiredModuleClazz) throws PluginParseException {
        if (!this.enabled) {
            throw new PluginParseException("Plugin module " + this.getKey() + " not enabled");
        }
        if (!requiredModuleClazz.isAssignableFrom(this.getModuleClass())) {
            throw new PluginParseException("Given module class: " + this.getModuleClass().getName() + " does not implement " + requiredModuleClazz.getName());
        }
    }

    @Override
    public String getCompleteKey() {
        return this.completeKey;
    }

    @Override
    public String getPluginKey() {
        return this.plugin.getKey();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getModuleClass() {
        return this.moduleClass;
    }

    @Override
    public abstract T getModule();

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map getParams() {
        return this.params;
    }

    @Override
    public String getI18nNameKey() {
        return this.i18nNameKey;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptors() {
        return this.resources.getResourceDescriptors();
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptors(String type) {
        return this.resources.getResourceDescriptors(type);
    }

    @Override
    public ResourceLocation getResourceLocation(String type, String name) {
        return this.resources.getResourceLocation(type, name);
    }

    @Override
    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.resources.getResourceDescriptor(type, name);
    }

    @Override
    public Float getMinJavaVersion() {
        return this.minJavaVersion;
    }

    @Override
    public boolean satisfiesMinJavaVersion() {
        if (this.minJavaVersion != null) {
            return JavaVersionUtils.satisfiesMinVersion(this.minJavaVersion.floatValue());
        }
        return true;
    }

    public void setPlugin(Plugin plugin) {
        this.completeKey = this.buildCompleteKey(plugin, this.key);
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return this.getCompleteKey() + " (" + this.getDescription() + ")";
    }

    @Override
    public void enabled() {
        this.loadClass(this.plugin, this.moduleClassName);
        this.enabled = true;
    }

    @Override
    public void disabled() {
        this.enabled = false;
    }
}

