/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.classloader;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelegationClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog(DelegationClassLoader.class);
    private ClassLoader delegateClassLoader = DelegationClassLoader.class.getClassLoader();

    public void setDelegateClassLoader(ClassLoader delegateClassLoader) {
        Validate.notNull((Object)delegateClassLoader, (String)"Can't set the delegation target to null");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Update class loader delegation from [" + this.delegateClassLoader + "] to [" + delegateClassLoader + "]"));
        }
        this.delegateClassLoader = delegateClassLoader;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.delegateClassLoader.loadClass(name);
    }

    public URL getResource(String name) {
        return this.delegateClassLoader.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.delegateClassLoader.getResourceAsStream(name);
    }

    public synchronized void setDefaultAssertionStatus(boolean enabled) {
        this.delegateClassLoader.setDefaultAssertionStatus(enabled);
    }

    public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegateClassLoader.setPackageAssertionStatus(packageName, enabled);
    }

    public synchronized void setClassAssertionStatus(String className, boolean enabled) {
        this.delegateClassLoader.setClassAssertionStatus(className, enabled);
    }

    public synchronized void clearAssertionStatus() {
        this.delegateClassLoader.clearAssertionStatus();
    }
}

