/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources
implements Resourced {
    public static final Resources EMPTY_RESOURCES = new Resources(Collections.<ResourceDescriptor>emptyList());
    private List<ResourceDescriptor> resourceDescriptors;

    public static Resources fromXml(Element element) throws PluginParseException, IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("Cannot parse resources from null XML element");
        }
        List elements = element.elements("resource");
        ArrayList<ResourceDescriptor> templates = new ArrayList<ResourceDescriptor>(elements.size());
        for (Element e : elements) {
            ResourceDescriptor resourceDescriptor = new ResourceDescriptor(e);
            if (templates.contains(resourceDescriptor)) {
                throw new PluginParseException("Duplicate resource with type '" + resourceDescriptor.getType() + "' and name '" + resourceDescriptor.getName() + "' found");
            }
            templates.add(resourceDescriptor);
        }
        return new Resources(templates);
    }

    public Resources(List<ResourceDescriptor> resourceDescriptors) throws IllegalArgumentException {
        if (resourceDescriptors == null) {
            throw new IllegalArgumentException("Resources cannot be created with a null resources list. Pass empty list instead");
        }
        this.resourceDescriptors = resourceDescriptors;
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptors() {
        return this.resourceDescriptors;
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptors(String type) {
        LinkedList<ResourceDescriptor> typedResourceDescriptors = new LinkedList<ResourceDescriptor>();
        for (ResourceDescriptor resourceDescriptor : this.resourceDescriptors) {
            if (!resourceDescriptor.getType().equalsIgnoreCase(type)) continue;
            typedResourceDescriptors.add(resourceDescriptor);
        }
        return typedResourceDescriptors;
    }

    @Override
    public ResourceLocation getResourceLocation(String type, String name) {
        for (ResourceDescriptor resourceDescriptor : this.resourceDescriptors) {
            if (!resourceDescriptor.doesTypeAndNameMatch(type, name)) continue;
            return resourceDescriptor.getResourceLocationForName(name);
        }
        return null;
    }

    @Override
    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        for (ResourceDescriptor resourceDescriptor : this.resourceDescriptors) {
            if (!resourceDescriptor.getType().equalsIgnoreCase(type) || !resourceDescriptor.getName().equalsIgnoreCase(name)) continue;
            return resourceDescriptor;
        }
        return null;
    }
}

