/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManagerState
implements Serializable {
    private Map<String, Boolean> map = new HashMap<String, Boolean>();

    public PluginManagerState() {
    }

    public PluginManagerState(Map<String, Boolean> map) {
        this.map = map;
    }

    public Boolean getState(String key) {
        return this.map.get(key);
    }

    public Map<String, Boolean> getMap() {
        return this.map;
    }

    public boolean isEnabled(Plugin plugin) {
        Boolean bool = this.getState(plugin.getKey());
        return bool == null ? plugin.isEnabledByDefault() : bool.booleanValue();
    }

    public boolean isEnabled(ModuleDescriptor pluginModule) {
        if (pluginModule == null) {
            return false;
        }
        Boolean bool = this.getState(pluginModule.getCompleteKey());
        return bool == null ? pluginModule.isEnabledByDefault() : bool.booleanValue();
    }

    public void setState(String key, Boolean enabled) {
        this.map.put(key, enabled);
    }

    public void removeState(String key) {
        this.map.remove(key);
    }

    public Map<String, Boolean> getPluginStateMap(Plugin plugin) {
        HashMap<String, Boolean> state = new HashMap<String, Boolean>(this.getMap());
        CollectionUtils.filter(state.keySet(), (Predicate)new StringStartsWith(plugin.getKey()));
        return state;
    }

    private static class StringStartsWith
    implements Predicate {
        private final String prefix;

        public StringStartsWith(String keyPrefix) {
            this.prefix = keyPrefix;
        }

        public boolean evaluate(Object object) {
            String str = (String)object;
            return str.startsWith(this.prefix);
        }
    }
}

