/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleDescriptorFactory
implements ModuleDescriptorFactory {
    private static Log log = LogFactory.getLog(DefaultModuleDescriptorFactory.class);
    private Map<String, Class<? extends ModuleDescriptor>> moduleDescriptorClasses;
    private List<String> permittedModuleKeys = Collections.emptyList();

    public DefaultModuleDescriptorFactory() {
        this.moduleDescriptorClasses = new HashMap<String, Class<? extends ModuleDescriptor>>();
    }

    @Override
    public Class<? extends ModuleDescriptor> getModuleDescriptorClass(String type) {
        return this.moduleDescriptorClasses.get(type);
    }

    @Override
    public ModuleDescriptor getModuleDescriptor(String type) throws PluginParseException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.shouldSkipModuleOfType(type)) {
            return null;
        }
        Class<? extends ModuleDescriptor> moduleDescriptorClazz = this.getModuleDescriptorClass(type);
        if (moduleDescriptorClazz == null) {
            throw new PluginParseException("Cannot find ModuleDescriptor class for plugin of type '" + type + "'.");
        }
        return moduleDescriptorClazz.newInstance();
    }

    protected boolean shouldSkipModuleOfType(String type) {
        return this.permittedModuleKeys != null && !this.permittedModuleKeys.isEmpty() && !this.permittedModuleKeys.contains(type);
    }

    public void setModuleDescriptors(Map<String, String> moduleDescriptorClassNames) {
        for (Map.Entry<String, String> entry : moduleDescriptorClassNames.entrySet()) {
            Class<? extends ModuleDescriptor> descriptorClass = this.getClassFromEntry(entry);
            if (descriptorClass == null) continue;
            this.addModuleDescriptor(entry.getKey(), descriptorClass);
        }
    }

    private Class<? extends ModuleDescriptor> getClassFromEntry(Map.Entry<String, String> entry) {
        if (this.shouldSkipModuleOfType(entry.getKey())) {
            return null;
        }
        Class<?> descriptorClass = null;
        try {
            descriptorClass = ClassLoaderUtils.loadClass(entry.getValue(), this.getClass());
            if (!ModuleDescriptor.class.isAssignableFrom(descriptorClass)) {
                log.error((Object)("Configured plugin module descriptor class " + entry.getValue() + " does not inherit from ModuleDescriptor"));
                descriptorClass = null;
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to add configured plugin module descriptor " + entry.getKey() + ". Class not found: " + entry.getValue()));
        }
        return descriptorClass;
    }

    @Override
    public boolean hasModuleDescriptor(String type) {
        return this.moduleDescriptorClasses.containsKey(type);
    }

    public void addModuleDescriptor(String type, Class<? extends ModuleDescriptor> moduleDescriptorClass) {
        this.moduleDescriptorClasses.put(type, moduleDescriptorClass);
    }

    public void removeModuleDescriptorForType(String type) {
        this.moduleDescriptorClasses.remove(type);
    }

    protected Map<String, Class<? extends ModuleDescriptor>> getDescriptorClassesMap() {
        return this.moduleDescriptorClasses;
    }

    public void setPermittedModuleKeys(List<String> permittedModuleKeys) {
        if (permittedModuleKeys == null) {
            permittedModuleKeys = Collections.emptyList();
        }
        this.permittedModuleKeys = permittedModuleKeys;
    }
}

