/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WaitUntil {
    private static final Log log = LogFactory.getLog(WaitUntil.class);

    private WaitUntil() {
    }

    public static boolean invoke(WaitCondition waitCondition) {
        return WaitUntil.invoke(waitCondition, 10);
    }

    public static boolean invoke(WaitCondition waitCondition, int tries) {
        boolean successful = false;
        for (int count = tries; count > 0; --count) {
            if (waitCondition.isFinished()) {
                successful = true;
                break;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(waitCondition.getWaitMessage() + ", " + count + " tries remaining"));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return successful;
    }

    public static interface WaitCondition {
        public boolean isFinished();

        public String getWaitMessage();
    }
}

