/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.DefaultPluginArtifactFactory;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactFactory;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.loaders.DirectoryPluginLoader;
import com.atlassian.plugin.loaders.DynamicPluginLoader;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.Scanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanningPluginLoader
implements DynamicPluginLoader {
    private static Log log = LogFactory.getLog(DirectoryPluginLoader.class);
    protected final Scanner scanner;
    protected final Map<DeploymentUnit, Plugin> plugins;
    protected final List<PluginFactory> pluginFactories;
    protected final PluginArtifactFactory pluginArtifactFactory;

    public ScanningPluginLoader(Scanner scanner, List<PluginFactory> pluginFactories, PluginEventManager pluginEventManager) {
        this(scanner, pluginFactories, new DefaultPluginArtifactFactory(), pluginEventManager);
    }

    public ScanningPluginLoader(Scanner scanner, List<PluginFactory> pluginFactories, PluginArtifactFactory pluginArtifactFactory, PluginEventManager pluginEventManager) {
        Validate.notNull(pluginFactories, (String)"The list of plugin factories must be specified");
        Validate.notNull((Object)pluginEventManager, (String)"The event manager must be specified");
        Validate.notNull((Object)scanner, (String)"The scanner must be specified");
        this.plugins = new HashMap<DeploymentUnit, Plugin>();
        this.pluginArtifactFactory = pluginArtifactFactory;
        this.scanner = scanner;
        this.pluginFactories = new ArrayList<PluginFactory>(pluginFactories);
        pluginEventManager.register(this);
    }

    @Override
    public Collection<Plugin> loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        this.scanner.scan();
        for (DeploymentUnit deploymentUnit : this.scanner.getDeploymentUnits()) {
            try {
                Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
                this.plugins.put(deploymentUnit, plugin);
            }
            catch (PluginParseException e) {
                log.error((Object)("Error loading descriptor for : " + deploymentUnit), (Throwable)e);
            }
        }
        if (this.scanner.getDeploymentUnits().isEmpty()) {
            log.info((Object)"No plugins found to be deployed");
        }
        return this.plugins.values();
    }

    protected Plugin deployPluginFromUnit(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Plugin plugin = null;
        String errorText = "No plugin factories found for plugin file " + deploymentUnit;
        for (PluginFactory factory : this.pluginFactories) {
            try {
                PluginArtifact artifact = this.pluginArtifactFactory.create(deploymentUnit.getPath().toURI());
                if (factory.canCreate(artifact) == null || (plugin = factory.create(deploymentUnit, moduleDescriptorFactory)) == null) continue;
                break;
            }
            catch (IllegalArgumentException ex) {
                errorText = ex.getMessage();
            }
        }
        if (plugin == null) {
            plugin = new UnloadablePlugin(errorText);
        } else {
            log.info((Object)("Plugin " + deploymentUnit + " created"));
        }
        return plugin;
    }

    @Override
    public boolean supportsRemoval() {
        return true;
    }

    @Override
    public boolean supportsAddition() {
        return true;
    }

    @Override
    public Collection<Plugin> addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Collection<DeploymentUnit> updatedDeploymentUnits = this.scanner.scan();
        ArrayList<Plugin> foundPlugins = new ArrayList<Plugin>();
        for (DeploymentUnit deploymentUnit : updatedDeploymentUnits) {
            if (this.plugins.containsKey(deploymentUnit)) continue;
            Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
            this.plugins.put(deploymentUnit, plugin);
            foundPlugins.add(plugin);
        }
        if (foundPlugins.isEmpty()) {
            log.info((Object)"No plugins found to be installed");
        }
        return foundPlugins;
    }

    @Override
    public void removePlugin(Plugin plugin) throws PluginException {
        if (plugin.isEnabled()) {
            throw new PluginException("Cannot remove an enabled plugin");
        }
        if (!plugin.isUninstallable()) {
            throw new PluginException("Cannot remove an uninstallable plugin: [" + plugin.getName() + "]");
        }
        DeploymentUnit deploymentUnit = this.findMatchingDeploymentUnit(plugin);
        plugin.close();
        try {
            boolean found = false;
            for (DeploymentUnit unit : this.plugins.keySet()) {
                if (!unit.getPath().equals(deploymentUnit.getPath()) || unit.equals(deploymentUnit)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.scanner.remove(deploymentUnit);
            }
        }
        catch (SecurityException e) {
            throw new PluginException(e);
        }
        this.plugins.remove(deploymentUnit);
        log.info((Object)("Removed plugin " + plugin.getKey()));
    }

    private DeploymentUnit findMatchingDeploymentUnit(Plugin plugin) throws PluginException {
        DeploymentUnit deploymentUnit = null;
        for (Map.Entry<DeploymentUnit, Plugin> entry : this.plugins.entrySet()) {
            if (entry.getValue() != plugin) continue;
            deploymentUnit = entry.getKey();
            break;
        }
        if (deploymentUnit == null) {
            throw new PluginException("This pluginLoader has no memory of deploying the plugin you are trying remove: [" + plugin.getName() + "]");
        }
        return deploymentUnit;
    }

    @PluginEventListener
    public void onShutdown(PluginFrameworkShutdownEvent event) {
        Iterator<Plugin> it = this.plugins.values().iterator();
        while (it.hasNext()) {
            Plugin plugin = it.next();
            plugin.close();
            it.remove();
        }
        this.scanner.reset();
    }

    public void shutDown() {
        this.onShutdown(null);
    }

    @Override
    public String canLoad(PluginArtifact pluginArtifact) throws PluginParseException {
        PluginFactory factory;
        String pluginKey = null;
        Iterator<PluginFactory> i$ = this.pluginFactories.iterator();
        while (i$.hasNext() && (pluginKey = (factory = i$.next()).canCreate(pluginArtifact)) == null) {
        }
        return pluginKey;
    }
}

