/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.impl;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.util.VersionStringComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlugin
implements Plugin,
Comparable<Plugin> {
    private String name;
    private String i18nNameKey;
    private String key;
    private Map<String, ModuleDescriptor<?>> modules = new LinkedHashMap();
    private boolean enabledByDefault = true;
    private PluginInformation pluginInformation = new PluginInformation();
    private boolean enabled;
    private boolean system;
    private Resourced resources = Resources.EMPTY_RESOURCES;
    private int pluginsVersion = 1;
    private Date dateLoaded = new Date();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getI18nNameKey() {
        return this.i18nNameKey;
    }

    @Override
    public void setI18nNameKey(String i18nNameKey) {
        this.i18nNameKey = i18nNameKey;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String aPackage) {
        this.key = aPackage;
    }

    @Override
    public void addModuleDescriptor(ModuleDescriptor<?> moduleDescriptor) {
        this.modules.put(moduleDescriptor.getKey(), moduleDescriptor);
    }

    protected void removeModuleDescriptor(String key) {
        this.modules.remove(key);
    }

    @Override
    public Collection<ModuleDescriptor<?>> getModuleDescriptors() {
        return new ArrayList(this.modules.values());
    }

    @Override
    public ModuleDescriptor<?> getModuleDescriptor(String key) {
        return this.modules.get(key);
    }

    @Override
    public <T> List<ModuleDescriptor<T>> getModuleDescriptorsByModuleClass(Class<T> aClass) {
        ArrayList<ModuleDescriptor<T>> result = new ArrayList<ModuleDescriptor<T>>();
        for (ModuleDescriptor<?> moduleDescriptor : this.modules.values()) {
            Class<?> moduleClass = moduleDescriptor.getModuleClass();
            if (!aClass.isAssignableFrom(moduleClass)) continue;
            result.add(moduleDescriptor);
        }
        return result;
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.enabledByDefault && (this.pluginInformation == null || this.pluginInformation.satisfiesMinJavaVersion());
    }

    @Override
    public void setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
    }

    @Override
    public int getPluginsVersion() {
        return this.pluginsVersion;
    }

    @Override
    public void setPluginsVersion(int pluginsVersion) {
        this.pluginsVersion = pluginsVersion;
    }

    @Override
    public PluginInformation getPluginInformation() {
        return this.pluginInformation;
    }

    @Override
    public void setPluginInformation(PluginInformation pluginInformation) {
        this.pluginInformation = pluginInformation;
    }

    @Override
    public void setResources(Resourced resources) {
        this.resources = resources != null ? resources : Resources.EMPTY_RESOURCES;
    }

    public List getResourceDescriptors() {
        return this.resources.getResourceDescriptors();
    }

    public List getResourceDescriptors(String type) {
        return this.resources.getResourceDescriptors(type);
    }

    @Override
    public ResourceLocation getResourceLocation(String type, String name) {
        return this.resources.getResourceLocation(type, name);
    }

    @Override
    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.resources.getResourceDescriptor(type, name);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSystemPlugin() {
        return this.system;
    }

    @Override
    public boolean containsSystemModule() {
        for (ModuleDescriptor<?> moduleDescriptor : this.modules.values()) {
            if (!moduleDescriptor.isSystemModule()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSystemPlugin(boolean system) {
        this.system = system;
    }

    @Override
    public Date getDateLoaded() {
        return this.dateLoaded;
    }

    @Override
    public int compareTo(Plugin otherPlugin) {
        if (otherPlugin.getKey() == null) {
            return 1;
        }
        if (this.getKey() == null) {
            return -1;
        }
        if (!otherPlugin.getKey().equals(this.getKey())) {
            return this.getKey().compareTo(otherPlugin.getKey());
        }
        String thisVersion = this.cleanVersionString(this.getPluginInformation() != null ? this.getPluginInformation().getVersion() : null);
        String otherVersion = this.cleanVersionString(otherPlugin.getPluginInformation() != null ? otherPlugin.getPluginInformation().getVersion() : null);
        if (!VersionStringComparator.isValidVersionString(thisVersion)) {
            return -1;
        }
        if (!VersionStringComparator.isValidVersionString(otherVersion)) {
            return -1;
        }
        return new VersionStringComparator().compare(thisVersion, otherVersion);
    }

    private String cleanVersionString(String version) {
        if (version == null || version.trim().equals("")) {
            return "0";
        }
        return version.replaceAll(" ", "");
    }

    public String toString() {
        PluginInformation info = this.getPluginInformation();
        return this.getKey() + ":" + (info == null ? "?" : info.getVersion());
    }
}

