/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.factories;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.XmlDynamicPlugin;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.dom4j.DocumentException;

public class XmlDynamicPluginFactory
implements PluginFactory {
    private DescriptorParserFactory descriptorParserFactory = new XmlDescriptorParserFactory();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Plugin create(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Validate.notNull((Object)deploymentUnit, (String)"The deployment unit must not be null");
        Validate.notNull((Object)moduleDescriptorFactory, (String)"The module descriptor factory must not be null");
        Plugin plugin = null;
        FileInputStream pluginDescriptor = null;
        try {
            pluginDescriptor = new FileInputStream(deploymentUnit.getPath());
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor);
            plugin = parser.configurePlugin(moduleDescriptorFactory, new XmlDynamicPlugin());
        }
        catch (RuntimeException e) {
            try {
                throw new PluginParseException(e);
                catch (IOException e2) {
                    throw new PluginParseException();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pluginDescriptor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact must not be null");
        String pluginKey = null;
        InputStream descriptorStream = pluginArtifact.getInputStream();
        if (descriptorStream != null) {
            try {
                DescriptorParser descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream);
                pluginKey = descriptorParser.getKey();
            }
            catch (PluginParseException ex) {
                if (!(ex.getCause() instanceof DocumentException)) {
                    throw ex;
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)descriptorStream);
            }
        }
        return pluginKey;
    }
}

