/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.event.impl;

import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.AnnotationListenerMethodSelector;
import com.atlassian.plugin.event.impl.ListenerMethodSelector;
import com.atlassian.plugin.event.impl.MethodNameListenerMethodSelector;
import com.atlassian.plugin.util.ClassUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultPluginEventManager
implements PluginEventManager {
    private final Map<Class, Set<Listener>> eventsToListener;
    private static final Log log = LogFactory.getLog(DefaultPluginEventManager.class);
    private final ListenerMethodSelector[] listenerMethodSelectors;

    public DefaultPluginEventManager() {
        this(new ListenerMethodSelector[]{new MethodNameListenerMethodSelector(), new AnnotationListenerMethodSelector()});
    }

    public DefaultPluginEventManager(ListenerMethodSelector[] selectors) {
        this.listenerMethodSelectors = selectors;
        this.eventsToListener = LazyMap.decorate(new HashMap(), (Factory)new Factory(){

            public Set<Listener> create() {
                return new HashSet<Listener>();
            }
        });
    }

    public synchronized void broadcast(Object event) {
        Validate.notNull((Object)event, (String)"The event to broadcast must not be null");
        HashSet<Listener> calledListeners = new HashSet<Listener>();
        for (Class type : ClassUtils.findAllTypes(event.getClass())) {
            Set<Listener> registrations = this.eventsToListener.get(type);
            for (Listener reg : registrations) {
                if (calledListeners.contains(reg)) continue;
                calledListeners.add(reg);
                reg.notify(event);
            }
        }
    }

    public synchronized void register(Object listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.forEveryListenerMethod(listener, new ListenerMethodHandler(){

            public void handle(Object listener, Method m) {
                if (m.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Listener methods must only have one argument");
                }
                Set listeners = (Set)DefaultPluginEventManager.this.eventsToListener.get(m.getParameterTypes()[0]);
                listeners.add(new Listener(listener, m));
            }
        });
    }

    public synchronized void unregister(Object listener) {
        this.forEveryListenerMethod(listener, new ListenerMethodHandler(){

            public void handle(Object listener, Method m) {
                Set listeners = (Set)DefaultPluginEventManager.this.eventsToListener.get(m.getParameterTypes()[0]);
                listeners.remove(new Listener(listener, m));
            }
        });
    }

    void forEveryListenerMethod(Object listener, ListenerMethodHandler handler) {
        Method[] methods = listener.getClass().getMethods();
        for (int x = 0; x < methods.length; ++x) {
            Method m = methods[x];
            for (int s = 0; s < this.listenerMethodSelectors.length; ++s) {
                ListenerMethodSelector selector = this.listenerMethodSelectors[s];
                if (!selector.isListenerMethod(m)) continue;
                handler.handle(listener, m);
            }
        }
    }

    private static class Listener {
        public final Object listener;
        public final Method method;

        public Listener(Object listener, Method method) {
            Validate.notNull((Object)listener);
            Validate.notNull((Object)method);
            this.listener = listener;
            this.method = method;
        }

        public void notify(Object event) {
            Validate.notNull((Object)event);
            try {
                this.method.invoke(this.listener, event);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Unable to access listener method: " + this.method), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Exception calling listener method", e.getCause());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Listener that = (Listener)o;
            if (!this.listener.equals(that.listener)) {
                return false;
            }
            return this.method.equals(that.method);
        }

        public int hashCode() {
            int result = this.listener.hashCode();
            result = 31 * result + this.method.hashCode();
            return result;
        }
    }

    private static interface ListenerMethodHandler {
        public void handle(Object var1, Method var2);
    }
}

