/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginManager;
import com.atlassian.plugin.PluginManagerState;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginStateStore;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.classloader.PluginsClassLoader;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartingEvent;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.loaders.DynamicPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.EnabledPluginPredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfClassPredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfTypePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.predicate.ModuleOfClassPredicate;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.atlassian.plugin.util.PluginUtils;
import com.atlassian.plugin.util.WaitUntil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginManager
implements PluginManager {
    private static final Log log = LogFactory.getLog(DefaultPluginManager.class);
    private final List<PluginLoader> pluginLoaders;
    private final PluginStateStore store;
    private final ModuleDescriptorFactory moduleDescriptorFactory;
    private final PluginsClassLoader classLoader;
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();
    private final PluginEventManager pluginEventManager;
    private PluginInstaller pluginInstaller;
    private final Map<Plugin, PluginLoader> pluginToPluginLoader = new HashMap<Plugin, PluginLoader>();

    public DefaultPluginManager(PluginStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager) {
        if (store == null) {
            throw new IllegalArgumentException("PluginStateStore must not be null.");
        }
        if (pluginLoaders == null) {
            throw new IllegalArgumentException("Plugin Loaders list must not be null.");
        }
        if (moduleDescriptorFactory == null) {
            throw new IllegalArgumentException("ModuleDescriptorFactory must not be null.");
        }
        if (pluginEventManager == null) {
            throw new IllegalArgumentException("PluginEventManager must not be null.");
        }
        this.pluginLoaders = pluginLoaders;
        this.store = store;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.pluginEventManager = pluginEventManager;
        this.classLoader = new PluginsClassLoader(this);
    }

    @Override
    public void init() throws PluginParseException {
        log.info((Object)"Initialising the plugin system");
        this.pluginEventManager.broadcast(new PluginFrameworkStartingEvent(this, this));
        for (PluginLoader loader : this.pluginLoaders) {
            if (loader == null) continue;
            this.addPlugins(loader, loader.loadAllPlugins(this.moduleDescriptorFactory));
        }
        this.pluginEventManager.broadcast(new PluginFrameworkStartedEvent(this, this));
    }

    @Override
    public void shutdown() {
        log.info((Object)"Shutting down the plugin system");
        this.pluginEventManager.broadcast(new PluginFrameworkShutdownEvent(this, this));
    }

    public void setPluginInstaller(PluginInstaller pluginInstaller) {
        this.pluginInstaller = pluginInstaller;
    }

    protected final PluginStateStore getStore() {
        return this.store;
    }

    @Override
    public String installPlugin(PluginArtifact pluginArtifact) throws PluginParseException {
        String key = this.validatePlugin(pluginArtifact);
        this.pluginInstaller.installPlugin(key, pluginArtifact);
        this.scanForNewPlugins();
        return key;
    }

    String validatePlugin(PluginArtifact pluginArtifact) throws PluginParseException {
        boolean foundADynamicPluginLoader = false;
        for (PluginLoader loader : this.pluginLoaders) {
            if (!(loader instanceof DynamicPluginLoader)) continue;
            foundADynamicPluginLoader = true;
            String key = ((DynamicPluginLoader)loader).canLoad(pluginArtifact);
            if (key == null) continue;
            return key;
        }
        if (!foundADynamicPluginLoader) {
            throw new IllegalStateException("Should be at least one DynamicPluginLoader in the plugin loader list");
        }
        throw new PluginParseException("Jar " + pluginArtifact.getName() + " is not a valid plugin");
    }

    @Override
    public int scanForNewPlugins() throws PluginParseException {
        int numberFound = 0;
        for (PluginLoader loader : this.pluginLoaders) {
            if (loader == null || !loader.supportsAddition()) continue;
            ArrayList<Plugin> pluginsToAdd = new ArrayList<Plugin>();
            for (Plugin plugin : loader.addFoundPlugins(this.moduleDescriptorFactory)) {
                if (!(plugin instanceof UnloadablePlugin) && PluginUtils.doesPluginRequireRestart(plugin)) {
                    try {
                        plugin.close();
                    }
                    catch (RuntimeException ex) {
                        log.warn((Object)"Unable to uninstall the plugin after it was determined to require a restart", (Throwable)ex);
                    }
                    UnloadablePlugin unloadablePlugin = new UnloadablePlugin("Plugin requires a restart of the application");
                    unloadablePlugin.setKey(plugin.getKey());
                    plugin = unloadablePlugin;
                }
                pluginsToAdd.add(plugin);
            }
            this.addPlugins(loader, pluginsToAdd);
            numberFound = pluginsToAdd.size();
        }
        return numberFound;
    }

    @Override
    public void uninstall(Plugin plugin) throws PluginException {
        this.unloadPlugin(plugin);
        this.removeStateFromStore(this.getStore(), plugin);
    }

    protected void removeStateFromStore(PluginStateStore stateStore, Plugin plugin) {
        PluginManagerState currentState = stateStore.loadPluginState();
        currentState.removeState(plugin.getKey());
        for (ModuleDescriptor<?> moduleDescriptor : plugin.getModuleDescriptors()) {
            currentState.removeState(moduleDescriptor.getCompleteKey());
        }
        stateStore.savePluginState(currentState);
    }

    protected void unloadPlugin(Plugin plugin) throws PluginException {
        if (!plugin.isUninstallable()) {
            throw new PluginException("Plugin is not uninstallable: " + plugin.getKey());
        }
        PluginLoader loader = this.pluginToPluginLoader.get(plugin);
        if (loader != null && !loader.supportsRemoval()) {
            throw new PluginException("Not uninstalling plugin - loader doesn't allow removal. Plugin: " + plugin.getKey());
        }
        if (this.isPluginEnabled(plugin.getKey())) {
            this.notifyPluginDisabled(plugin);
        }
        this.notifyUninstallPlugin(plugin);
        if (loader != null) {
            this.removePluginFromLoader(plugin);
        }
        this.plugins.remove(plugin.getKey());
    }

    private void removePluginFromLoader(Plugin plugin) throws PluginException {
        if (plugin.isDeleteable()) {
            PluginLoader pluginLoader = this.pluginToPluginLoader.get(plugin);
            pluginLoader.removePlugin(plugin);
        }
        this.pluginToPluginLoader.remove(plugin);
    }

    protected void notifyUninstallPlugin(Plugin plugin) {
        this.classLoader.notifyUninstallPlugin(plugin);
        for (ModuleDescriptor<?> descriptor : plugin.getModuleDescriptors()) {
            descriptor.destroy(plugin);
        }
    }

    protected PluginManagerState getState() {
        return this.getStore().loadPluginState();
    }

    protected void addPlugin(PluginLoader loader, Plugin plugin) throws PluginParseException {
        this.addPlugins(loader, Collections.singletonList(plugin));
    }

    protected void addPlugins(PluginLoader loader, Collection<Plugin> pluginsToAdd) throws PluginParseException {
        final HashSet<Plugin> pluginsThatShouldBeEnabled = new HashSet<Plugin>();
        for (Plugin plugin : new TreeSet<Plugin>(pluginsToAdd)) {
            if (this.plugins.containsKey(plugin.getKey())) {
                Plugin existingPlugin = this.plugins.get(plugin.getKey());
                if (plugin.compareTo(existingPlugin) >= 0) {
                    try {
                        this.updatePlugin(existingPlugin, plugin);
                    }
                    catch (PluginException e) {
                        throw new PluginParseException("Duplicate plugin found (installed version is the same or older) and could not be unloaded: '" + plugin.getKey() + "'", e);
                    }
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Duplicate plugin found (installed version is newer): '" + plugin.getKey() + "'"));
                    continue;
                }
            }
            this.plugins.put(plugin.getKey(), plugin);
            if (this.isPluginEnabled(plugin.getKey())) {
                try {
                    plugin.setEnabled(true);
                    pluginsThatShouldBeEnabled.add(plugin);
                }
                catch (RuntimeException ex) {
                    log.error((Object)("Unable to enable plugin " + plugin.getKey()), (Throwable)ex);
                }
            }
            this.pluginToPluginLoader.put(plugin, loader);
        }
        if (!this.plugins.isEmpty()) {
            WaitUntil.invoke(new WaitUntil.WaitCondition(){

                public boolean isFinished() {
                    Iterator i = pluginsThatShouldBeEnabled.iterator();
                    while (i.hasNext()) {
                        Plugin plugin = (Plugin)i.next();
                        if (!plugin.isEnabled()) continue;
                        i.remove();
                    }
                    return pluginsThatShouldBeEnabled.isEmpty();
                }

                public String getWaitMessage() {
                    return "Plugins that have yet to start: " + pluginsThatShouldBeEnabled;
                }
            }, 60);
            if (!pluginsThatShouldBeEnabled.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Plugin plugin : pluginsThatShouldBeEnabled) {
                    sb.append(plugin.getKey()).append(',');
                    this.disablePlugin(plugin.getKey());
                }
                sb.deleteCharAt(sb.length() - 1);
                log.error((Object)("Unable to start the following plugins: " + sb.toString()));
            }
        }
        for (Plugin plugin : pluginsToAdd) {
            if (!plugin.isEnabled()) continue;
            this.enablePluginModules(plugin);
        }
    }

    protected void updatePlugin(Plugin oldPlugin, Plugin newPlugin) throws PluginException {
        if (!oldPlugin.getKey().equals(newPlugin.getKey())) {
            throw new IllegalArgumentException("New plugin must have the same key as the old plugin");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Updating plugin '" + oldPlugin + "' to '" + newPlugin + "'"));
        }
        Map<String, Boolean> oldPluginState = this.getState().getPluginStateMap(oldPlugin);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Uninstalling old plugin: " + oldPlugin));
        }
        this.uninstall(oldPlugin);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Plugin uninstalled '" + oldPlugin + "', preserving old state"));
        }
        final HashSet<String> newModuleKeys = new HashSet<String>();
        newModuleKeys.add(newPlugin.getKey());
        for (ModuleDescriptor<?> moduleDescriptor : newPlugin.getModuleDescriptors()) {
            newModuleKeys.add(moduleDescriptor.getCompleteKey());
        }
        CollectionUtils.filter(oldPluginState.keySet(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return newModuleKeys.contains(o);
            }
        });
        PluginManagerState currentState = this.getState();
        currentState.getMap().putAll(oldPluginState);
        this.getStore().savePluginState(currentState);
    }

    @Override
    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    @Override
    public Collection<Plugin> getPlugins(final PluginPredicate pluginPredicate) {
        return CollectionUtils.select(this.getPlugins(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return pluginPredicate.matches((Plugin)o);
            }
        });
    }

    @Override
    public Collection<Plugin> getEnabledPlugins() {
        return this.getPlugins(new EnabledPluginPredicate(this));
    }

    @Override
    public <T> Collection<T> getModules(ModuleDescriptorPredicate<T> moduleDescriptorPredicate) {
        Collection<ModuleDescriptor<T>> moduleDescriptors = this.getModuleDescriptors(moduleDescriptorPredicate);
        return this.getModules(moduleDescriptors);
    }

    @Override
    public <T> Collection<ModuleDescriptor<T>> getModuleDescriptors(final ModuleDescriptorPredicate<T> moduleDescriptorPredicate) {
        ArrayList<ModuleDescriptor<T>> moduleDescriptors = new ArrayList<ModuleDescriptor<T>>();
        for (ModuleDescriptor<?> desc : this.getModuleDescriptors(this.getPlugins())) {
            moduleDescriptors.add(desc);
        }
        CollectionUtils.filter(moduleDescriptors, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return moduleDescriptorPredicate.matches((ModuleDescriptor)o);
            }
        });
        return moduleDescriptors;
    }

    private Collection<ModuleDescriptor<?>> getModuleDescriptors(Collection<Plugin> plugins) {
        LinkedList moduleDescriptors = new LinkedList();
        for (Plugin plugin : plugins) {
            moduleDescriptors.addAll(plugin.getModuleDescriptors());
        }
        return moduleDescriptors;
    }

    private <T> List<T> getModules(Collection<ModuleDescriptor<T>> moduleDescriptors) {
        final ArrayList result = new ArrayList();
        CollectionUtils.forAllDo(moduleDescriptors, (Closure)new Closure(){

            public void execute(Object o) {
                CollectionUtils.addIgnoreNull((Collection)result, ((ModuleDescriptor)o).getModule());
            }
        });
        return result;
    }

    @Override
    public Plugin getPlugin(String key) {
        return this.plugins.get(key);
    }

    @Override
    public Plugin getEnabledPlugin(String pluginKey) {
        if (!this.isPluginEnabled(pluginKey)) {
            return null;
        }
        return this.getPlugin(pluginKey);
    }

    @Override
    public ModuleDescriptor getPluginModule(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        Plugin plugin = this.getPlugin(key.getPluginKey());
        if (plugin == null) {
            return null;
        }
        return plugin.getModuleDescriptor(key.getModuleKey());
    }

    @Override
    public ModuleDescriptor getEnabledPluginModule(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        if (!this.isPluginModuleEnabled(completeKey)) {
            return null;
        }
        return this.getEnabledPlugin(key.getPluginKey()).getModuleDescriptor(key.getModuleKey());
    }

    @Override
    public <T> List<T> getEnabledModulesByClass(Class<T> moduleClass) {
        return this.getModules(this.getEnabledModuleDescriptorsByModuleClass(moduleClass));
    }

    @Override
    public <T> List<T> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<T>>[] descriptorClasses, Class<T> moduleClass) {
        Collection<ModuleDescriptor<T>> moduleDescriptors = this.getEnabledModuleDescriptorsByModuleClass(moduleClass);
        DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new ModuleDescriptorOfClassPredicate(descriptorClasses));
        return this.getModules(moduleDescriptors);
    }

    @Override
    public <T> List<T> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<T>> descriptorClass, Class<T> moduleClass) {
        Collection<ModuleDescriptor<T>> moduleDescriptors = this.getEnabledModuleDescriptorsByModuleClass(moduleClass);
        DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new ModuleDescriptorOfClassPredicate(descriptorClass));
        return this.getModules(moduleDescriptors);
    }

    private <T> Collection<ModuleDescriptor<T>> getEnabledModuleDescriptorsByModuleClass(Class<T> moduleClass) {
        Collection<ModuleDescriptor<?>> moduleDescriptors = this.getModuleDescriptors(this.getEnabledPlugins());
        DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new ModuleOfClassPredicate(moduleClass));
        DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new EnabledModulePredicate(this));
        ArrayList<ModuleDescriptor<T>> list = new ArrayList<ModuleDescriptor<T>>();
        for (ModuleDescriptor<?> o : moduleDescriptors) {
            list.add(o);
        }
        return list;
    }

    @Override
    public <T extends ModuleDescriptor> List<T> getEnabledModuleDescriptorsByClass(Class<T> moduleDescriptorClass) {
        return this.getEnabledModuleDescriptorsByClass(moduleDescriptorClass, false);
    }

    @Override
    public <T extends ModuleDescriptor> List<T> getEnabledModuleDescriptorsByClass(Class<T> moduleDescriptorClass, boolean verbose) {
        LinkedList result = new LinkedList();
        for (Plugin plugin : this.plugins.values()) {
            if (!this.isPluginEnabled(plugin.getKey())) {
                if (!verbose || !log.isInfoEnabled()) continue;
                log.info((Object)("Plugin [" + plugin.getKey() + "] is disabled."));
                continue;
            }
            for (ModuleDescriptor<?> module : plugin.getModuleDescriptors()) {
                if (moduleDescriptorClass.isInstance(module) && this.isPluginModuleEnabled(module.getCompleteKey())) {
                    result.add(module);
                    continue;
                }
                if (!verbose || !log.isInfoEnabled()) continue;
                log.info((Object)("Module [" + module.getCompleteKey() + "] is disabled."));
            }
        }
        return result;
    }

    public List<ModuleDescriptor<?>> getEnabledModuleDescriptorsByType(String type) throws PluginParseException, IllegalArgumentException {
        Collection<ModuleDescriptor<?>> moduleDescriptors = this.getModuleDescriptors(this.getEnabledPlugins());
        DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new ModuleDescriptorOfTypePredicate(this.moduleDescriptorFactory, type));
        DefaultPluginManager.filterModuleDescriptors(moduleDescriptors, new EnabledModulePredicate(this));
        return (List)moduleDescriptors;
    }

    private static void filterModuleDescriptors(Collection moduleDescriptors, final ModuleDescriptorPredicate moduleDescriptorPredicate) {
        CollectionUtils.filter((Collection)moduleDescriptors, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return moduleDescriptorPredicate.matches((ModuleDescriptor)o);
            }
        });
    }

    @Override
    public void enablePlugin(String key) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a plugin key to disable.");
        }
        if (!this.plugins.containsKey(key)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No plugin was found for key '" + key + "'. Not enabling."));
            }
            return;
        }
        Plugin plugin = this.plugins.get(key);
        if (!plugin.getPluginInformation().satisfiesMinJavaVersion()) {
            log.error((Object)("Minimum Java version of '" + plugin.getPluginInformation().getMinJavaVersion() + "' was not satisfied for module '" + key + "'. Not enabling."));
            return;
        }
        plugin.setEnabled(true);
        if (WaitUntil.invoke(new PluginEnabledCondition(plugin))) {
            this.enablePluginState(plugin, this.getStore());
            this.notifyPluginEnabled(plugin);
        }
    }

    protected void enablePluginState(Plugin plugin, PluginStateStore stateStore) {
        PluginManagerState currentState = stateStore.loadPluginState();
        String key = plugin.getKey();
        if (!plugin.isEnabledByDefault()) {
            currentState.setState(key, Boolean.TRUE);
        } else {
            currentState.removeState(key);
        }
        stateStore.savePluginState(currentState);
    }

    protected void notifyPluginEnabled(Plugin plugin) {
        this.classLoader.notifyPluginOrModuleEnabled();
        this.enablePluginModules(plugin);
        this.pluginEventManager.broadcast(new PluginEnabledEvent(plugin));
    }

    private void enablePluginModules(Plugin plugin) {
        for (ModuleDescriptor<?> descriptor : plugin.getModuleDescriptors()) {
            if (!(descriptor instanceof StateAware)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("ModuleDescriptor '" + descriptor.getName() + "' is not StateAware. No need to enable."));
                continue;
            }
            if (!this.isPluginModuleEnabled(descriptor.getCompleteKey())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Plugin module is disabled, so not enabling ModuleDescriptor '" + descriptor.getName() + "'."));
                continue;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Enabling " + descriptor.getKey()));
                }
                ((StateAware)((Object)descriptor)).enabled();
            }
            catch (Throwable exception) {
                log.error((Object)("There was an error loading the descriptor '" + descriptor.getName() + "' of plugin '" + plugin.getKey() + "'. Disabling."), exception);
                this.replacePluginWithUnloadablePlugin(plugin, descriptor, exception);
            }
        }
        this.classLoader.notifyPluginOrModuleEnabled();
    }

    @Override
    public void disablePlugin(String key) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a plugin key to disable.");
        }
        if (!this.plugins.containsKey(key)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No plugin was found for key '" + key + "'. Not disabling."));
            }
            return;
        }
        Plugin plugin = this.plugins.get(key);
        this.notifyPluginDisabled(plugin);
        this.disablePluginState(plugin, this.getStore());
    }

    protected void disablePluginState(Plugin plugin, PluginStateStore stateStore) {
        String key = plugin.getKey();
        PluginManagerState currentState = stateStore.loadPluginState();
        if (plugin.isEnabledByDefault()) {
            currentState.setState(key, Boolean.FALSE);
        } else {
            currentState.removeState(key);
        }
        stateStore.savePluginState(currentState);
    }

    protected List<String> getEnabledStateAwareModuleKeys(Plugin plugin) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList moduleDescriptors = new ArrayList(plugin.getModuleDescriptors());
        Collections.reverse(moduleDescriptors);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (!(moduleDescriptor instanceof StateAware) || !this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey())) continue;
            keys.add(moduleDescriptor.getCompleteKey());
        }
        return keys;
    }

    protected void notifyPluginDisabled(Plugin plugin) {
        List<String> keysToDisable = this.getEnabledStateAwareModuleKeys(plugin);
        for (String key : keysToDisable) {
            StateAware descriptor = (StateAware)((Object)this.getPluginModule(key));
            descriptor.disabled();
        }
        plugin.setEnabled(false);
        this.pluginEventManager.broadcast(new PluginDisabledEvent(plugin));
    }

    @Override
    public void disablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Returned module for key '" + completeKey + "' was null. Not disabling."));
            }
            return;
        }
        this.disablePluginModuleState(module, this.getStore());
        this.notifyModuleDisabled(module);
    }

    protected void disablePluginModuleState(ModuleDescriptor module, PluginStateStore stateStore) {
        String completeKey = module.getCompleteKey();
        PluginManagerState currentState = stateStore.loadPluginState();
        if (module.isEnabledByDefault()) {
            currentState.setState(completeKey, Boolean.FALSE);
        } else {
            currentState.removeState(completeKey);
        }
        stateStore.savePluginState(currentState);
    }

    protected void notifyModuleDisabled(ModuleDescriptor module) {
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).disabled();
        }
    }

    @Override
    public void enablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Returned module for key '" + completeKey + "' was null. Not enabling."));
            }
            return;
        }
        if (!module.satisfiesMinJavaVersion()) {
            log.error((Object)("Minimum Java version of '" + module.getMinJavaVersion() + "' was not satisfied for module '" + completeKey + "'. Not enabling."));
            return;
        }
        this.enablePluginModuleState(module, this.getStore());
        this.notifyModuleEnabled(module);
    }

    protected void enablePluginModuleState(ModuleDescriptor module, PluginStateStore stateStore) {
        String completeKey = module.getCompleteKey();
        PluginManagerState currentState = stateStore.loadPluginState();
        if (!module.isEnabledByDefault()) {
            currentState.setState(completeKey, Boolean.TRUE);
        } else {
            currentState.removeState(completeKey);
        }
        stateStore.savePluginState(currentState);
    }

    protected void notifyModuleEnabled(ModuleDescriptor module) {
        this.classLoader.notifyPluginOrModuleEnabled();
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).enabled();
        }
    }

    @Override
    public boolean isPluginModuleEnabled(String completeKey) {
        if (completeKey == null) {
            return false;
        }
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        ModuleDescriptor pluginModule = this.getPluginModule(completeKey);
        return this.isPluginEnabled(key.getPluginKey()) && pluginModule != null && this.getState().isEnabled(pluginModule);
    }

    @Override
    public boolean isPluginEnabled(String key) {
        return this.plugins.containsKey(key) && this.getState().isEnabled(this.plugins.get(key));
    }

    @Override
    public InputStream getDynamicResourceAsStream(String name) {
        return this.getClassLoader().getResourceAsStream(name);
    }

    public Class getDynamicPluginClass(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public InputStream getPluginResourceAsStream(String pluginKey, String resourcePath) {
        Plugin plugin = this.getEnabledPlugin(pluginKey);
        if (plugin == null) {
            log.error((Object)("Attempted to retreive resource " + resourcePath + " for non-existent or inactive plugin " + pluginKey));
            return null;
        }
        return plugin.getResourceAsStream(resourcePath);
    }

    private UnloadablePlugin replacePluginWithUnloadablePlugin(Plugin plugin, ModuleDescriptor descriptor, Throwable throwable) {
        UnloadableModuleDescriptor unloadableDescriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, descriptor, throwable);
        UnloadablePlugin unloadablePlugin = UnloadablePluginFactory.createUnloadablePlugin(plugin, unloadableDescriptor);
        unloadablePlugin.setUninstallable(plugin.isUninstallable());
        unloadablePlugin.setDeletable(plugin.isDeleteable());
        this.plugins.put(plugin.getKey(), unloadablePlugin);
        this.disablePluginState(plugin, this.getStore());
        return unloadablePlugin;
    }

    @Override
    public boolean isSystemPlugin(String key) {
        Plugin plugin = this.getPlugin(key);
        return plugin != null && plugin.isSystemPlugin();
    }

    public void setDescriptorParserFactory(DescriptorParserFactory descriptorParserFactory) {
    }

    private static class PluginEnabledCondition
    implements WaitUntil.WaitCondition {
        private final Plugin plugin;

        public PluginEnabledCondition(Plugin plugin) {
            this.plugin = plugin;
        }

        public boolean isFinished() {
            return this.plugin.isEnabled();
        }

        public String getWaitMessage() {
            return "Waiting until plugin " + this.plugin + " is enabled";
        }
    }
}

