/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.InstallationMode;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginPermission;
import com.atlassian.plugin.RequirePermission;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;

public final class Permissions {
    public static final String ALL_PERMISSIONS = "all_permissions";
    public static final String EXECUTE_JAVA = "execute_java";
    public static final String CREATE_SYSTEM_MODULES = "create_system_modules";
    public static final String GENERATE_ANY_HTML = "generate_any_html";

    private Permissions() {
    }

    public static Set<String> getRequiredPermissions(Class<?> type) {
        Class<RequirePermission> annotation = RequirePermission.class;
        if (type != null && type.isAnnotationPresent(annotation)) {
            return ImmutableSet.copyOf((Object[])type.getAnnotation(annotation).value());
        }
        return ImmutableSet.of();
    }

    public static Plugin addPermission(Plugin plugin, String permission, InstallationMode mode) {
        Preconditions.checkNotNull((Object)plugin);
        Permissions.getPluginInformation(plugin).setPermissions((Set<PluginPermission>)ImmutableSet.builder().addAll(Permissions.getPluginInformation(plugin).getPermissions()).add((Object)new PluginPermission(permission, mode)).build());
        return plugin;
    }

    private static PluginInformation getPluginInformation(Plugin plugin) {
        return Optional.ofNullable(plugin.getPluginInformation()).orElseGet(PluginInformation::new);
    }
}

