define('atlassian-nps-plugin/js/nps/util', [
    'atlassian-nps-plugin/js/nps/product',
    'atlassian-nps-plugin/js/amd-shims/ajs'
],
/**
 * Helper functions.
 * @param Product adapter for a specific product such as JIRA or Confluence
 * @param AJS
 * @tainted AJS.trigger
 */
function (
    Product,
    AJS
) {
    "use strict";

    var Util = {};

    /**
     * Fisher-Yates shuffle algorithm (http://en.wikipedia.org/wiki/Fisher%E2%80%93Yates_shuffle)
     *
     * Helpful for removing bias that can occur with ordering.
     *
     * Note: Original array will be modified.
     *
     * @param array - Array which will be shuffled in place
     * @returns Array - same array which was supplied
     */
    Util.kfyShuffle = function (array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
        return array;
    };

    /**
     * Send an analytic event.
     * The specified event name has the id automatically appended to it.
     * @param eventName
     * @param data
     */
    Util.sendAnalyticsEvent = function (eventName, data) {
        data = data || {};

        // explicity include product into our analytics events.
        // This was added to handle the JIRA / JIRA Service Desk case
        // Put "product" into whitelist of analytics-whitelist plugin if
        // want to actually have this value sent instead of what analytics
        // adds for you for product attribute
        data.product = Product.getProductName().toLowerCase();

        // we also want to include page on every event. add to whitelist to see
        data.page = window.location.pathname.replace(/\//g, ' ');

        var payload = {name: "nps." + eventName, data: data};
        AJS.trigger("analyticsEvent", payload);
    };

    /**
     * Check if there is a dialog is showing on page
     * @returns {boolean}
     */
    Util.hasShowingDialog = function () {
        return AJS.$('.aui-dialog:visible, aui-dialog2:visible').length > 0;
    };

    return Util;
});
