require([
    'jquery',
    'atlassian-nps-plugin/js/amd-shims/ajs',
    'atlassian-nps-plugin/js/nps/server/btf-admin'
],
/**
 * This allows the NPS code to be used when a system administrator is on the analytics
 * admin page (URL is hardcoded).
 * @param $ jQuery
 * @param AJS
 * @param Admin handles the enabling/disabling of NPS surveys on the instance
 */
function(
    $,
    AJS,
    Admin
) {
    "use strict";

    var analyticsUrl = 'plugins/servlet/analytics/configuration';
    // check if on analytics config page
    if (document.URL.indexOf(analyticsUrl) > -1) {
        AJS.toInit(function() {
            var $form = $('#analytics-enable-form');
            Admin.init($form);
        });
    }
});
