/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin.tracker;

import com.atlassian.nps.plugin.tracker.MethodConfiguration;
import java.lang.reflect.Method;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MethodReflectingServiceServiceTracker
extends ServiceTracker {
    private static final Logger log = LoggerFactory.getLogger(MethodReflectingServiceServiceTracker.class);
    private final String className;

    MethodReflectingServiceServiceTracker(BundleContext context, String className) {
        super(context, className, null);
        this.className = className;
    }

    public final Object addingService(ServiceReference reference) {
        try {
            Object service = super.addingService(reference);
            this.acquireMethodReferences(service);
            return service;
        }
        catch (Exception e) {
            this.forgetMethodReferences();
            log.warn("Exception when adding the service " + this.className, (Throwable)e);
            return null;
        }
    }

    public final void removedService(ServiceReference reference, Object service) {
        this.forgetMethodReferences();
        super.removedService(reference, service);
    }

    public final void modifiedService(ServiceReference reference, Object service) {
        this.acquireMethodReferences(service);
    }

    protected Method getMethodByReflection(Object service, MethodConfiguration methodConfiguration) {
        try {
            return service.getClass().getMethod(methodConfiguration.getName(), methodConfiguration.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            log.error("Error reflecting on " + this.className + "#" + methodConfiguration.getName(), (Throwable)e);
            return null;
        }
    }

    protected abstract void acquireMethodReferences(Object var1);

    protected abstract void forgetMethodReferences();
}

