/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin.storage;

import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.google.common.base.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServerStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(UserServerStorageService.class);
    private final UserSettingsService userSettingsService;

    public UserServerStorageService(UserSettingsService userSettingsService) {
        this.userSettingsService = userSettingsService;
    }

    public boolean putSetting(UserKey userKey, final String key, final String newValue) {
        if (userKey != null) {
            try {
                this.userSettingsService.updateUserSettings(userKey, (Function)new Function<UserSettingsBuilder, UserSettings>(){

                    public UserSettings apply(UserSettingsBuilder userSettingsBuilder) {
                        return userSettingsBuilder.put(key, newValue).build();
                    }
                });
                return true;
            }
            catch (RuntimeException e) {
                LOG.warn("Couldn't change the NPS settings. This can safely be ignored during plugin shutdown. Detail: " + e.getMessage());
            }
        }
        return false;
    }

    public String getSetting(UserKey userKey, String key) {
        if (userKey != null) {
            try {
                Option valueOption = this.userSettingsService.getUserSettings(userKey).getString(key);
                if (valueOption.isDefined()) {
                    return (String)valueOption.get();
                }
                return null;
            }
            catch (RuntimeException e) {
                LOG.warn("Couldn't check the NPS settings. This can safely be ignored during plugin shutdown. Detail: " + e.getMessage());
            }
        }
        return null;
    }

    public void deleteSetting(UserKey userKey, final String key) {
        if (userKey != null) {
            try {
                this.userSettingsService.updateUserSettings(userKey, (Function)new Function<UserSettingsBuilder, UserSettings>(){

                    public UserSettings apply(UserSettingsBuilder userSettingsBuilder) {
                        return userSettingsBuilder.remove(key).build();
                    }
                });
            }
            catch (RuntimeException e) {
                LOG.warn("Couldn't delete the NPS settings. This can safely be ignored during plugin shutdown. Detail: " + e.getMessage());
            }
        }
    }
}

