define('atlassian-nps-plugin/js/nps/product', [
    'atlassian-nps-plugin/js/amd-shims/wrm'
], function(
    WRM
) {
    'use strict';

    var NAMESPACE = 'com.atlassian.plugins.atlassian-nps-plugin:atlassian-nps-plugin-resources';
    var cachedValues = {};

    function getValueOf(key) {
        if (cachedValues[key] === void 0) {
            cachedValues[key] = WRM.data.claim([NAMESPACE, key].join('.'));
        }
        return cachedValues[key];
    }

    return {
        setBindings: function() {},

        getProductName: function() {
            return 'Crowd';
        },

        getUserKey: function() {
            return getValueOf('user-name-data-provider');
        },

        isServerMode: function() {
            return true;
        },

        enableABTesting: function() {
            return false;
        },

        allowDisplayNotification: function() {
            return true;
        },

        getSurveyTrigger: function() {
            return '#user-dropdown';
        },

        allowDisplayAcknowledgementFlag: function() {
            return true;
        }
    };
});
