/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin.tracker;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MethodConfiguration {
    private static final Class<?>[] EMPTY_PARAMETER_ARRAY = new Class[0];
    private final String name;
    private final Supplier<List<Class<?>>> parameterTypesSupplier;

    public MethodConfiguration(String name, final Class<?> ... parameterTypes) {
        this(name, new Supplier<List<Class<?>>>(){

            public List<Class<?>> get() {
                if (parameterTypes != null) {
                    return Arrays.asList(parameterTypes);
                }
                return Collections.emptyList();
            }
        });
    }

    public MethodConfiguration(String name, Supplier<List<Class<?>>> parameterTypesSupplier) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"method name is required and must be set in constructor");
        this.name = name;
        this.parameterTypesSupplier = (Supplier)Preconditions.checkNotNull(parameterTypesSupplier, (Object)"parameterTypesSupplier is required and must be set in constructor");
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        List types = (List)this.parameterTypesSupplier.get();
        if (types == null || types.isEmpty()) {
            return EMPTY_PARAMETER_ARRAY;
        }
        return types.toArray(new Class[types.size()]);
    }
}

