/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin.fisheye;

import com.atlassian.crucible.spi.services.ImpersonationService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.condition.UrlReadingCondition;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import java.util.Map;

public class NonAnonymousUserCondition
implements UrlReadingCondition {
    private final ImpersonationService userProvider;
    private static final String QUERY_PARAM_NAME = "non-anonymous-user";

    public NonAnonymousUserCondition(ImpersonationService userProvider) {
        this.userProvider = userProvider;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isNotAnonymous()) {
            urlBuilder.addToQueryString(QUERY_PARAM_NAME, String.valueOf(true));
        }
    }

    public boolean shouldDisplay(QueryParams params) {
        return Boolean.valueOf(params.get(QUERY_PARAM_NAME));
    }

    private boolean isNotAnonymous() {
        return this.userProvider.getCurrentUserName(null) != null;
    }
}

