(function ($, NL) {
    NL.AppSwitcher = function (options) {
        var ADMIN_EDIT_PATH = AJS.contextPath() + "/plugins/servlet/customize-application-navigator";
        var that = this;
        this.$dropdown = null;

        options = $.extend({
            dropdownContents: null
        }, options);

        this.getLinks = function () {
            return $.ajax({
                url: AJS.contextPath() + '/rest/menu/latest/appswitcher',
                cache: false,
                dataType: 'json'
            }).done(this.updateDropdown).fail(this.showError);
        };

        this.getDropdown = function () {
            if (!this.$dropdown) {
                this.$dropdown = $(options.dropdownContents);
            }
            return this.$dropdown;
        };

        this.updateDropdown = function (data) {
            $(function () {
                that.getDropdown().html(navlinks.templates.appswitcher_old.applications({
                    apps: data,
                    showAdminLink: NL.environment.isUserAdmin,
                    adminLink: ADMIN_EDIT_PATH
                }));

                that.bindAnalyticsHandlers(that.getDropdown(), data);
                if (window.NL.environment.isAppSuggestionAvailable) {
                    that.handleSuggestionApps(data);
                }
            });
        };

        this.bindAnalyticsHandlers = function ($sidebar, apps) {
        };

        this.handleSuggestionApps = function(data) {

            var installedApps = _.map(data, function (app) {
                return app.applicationType.toLowerCase();
            });

            $suggestionApps = $("<div id='app-switcher-suggestion-apps' class='aui-dropdown2-section'/>");
            $suggestionApps.html(navlinks.templates.appswitcher_old.suggestionApps);

            var apps = $suggestionApps.find('.suggestion-apps');
            var hasSuggestionApps = false;
            _.each(suggestions, function(value) {
                if (!_.contains(installedApps, value.appName)) {
                    hasSuggestionApps = true;
                    apps.append(navlinks.templates.appswitcher_old.suggestionApp({appName:value.appName, appDesc:value.appDesc}));
                }
            });

            if (!hasSuggestionApps) return;

            $("#app-switcher").append($suggestionApps);

            $('.app-discovery-suggestion-app').click(function () {
                AJS.trigger("analytics", {name: "appswitcher.discovery.user.select." + $(this).find("a").attr("id").toLowerCase()});
                window.open($(this).find("a").attr("title"),  "_blank");

            });

            $('.app-discovery-suggestion-app').hover(function () {
                $(this).find("a").removeClass("active").removeClass("aui-dropdown2-active");
            });

            $('.app-discovery-cancel-button').click(function () {
                AJS.trigger("analytics", {name: "appswitcher.discovery.nothanks.button.click"});
                storeUserStorageData(KEY_NO_THANKS, "true");
                $suggestionApps.remove();
            });
        };

        this.showError = function () {
            $(function () {
                that.getDropdown()
                        .html(navlinks.templates.appswitcher_old.error())
                        .off('.appswitcher')
                        .on('click.appswitcher', '.app-switcher-retry', $.proxy(that.retryLoading, that));
            });
        };

        this.retryLoading = function (e) {
            this.getDropdown().html(navlinks.templates.appswitcher_old.loading());
            this.getLinks();
            e && e.stopPropagation();
        };

        this.getLinks();
    };

    var KEY_NO_THANKS = "key-no-thanks";
    var suggestions = [{appName:"jira", appDesc:AJS.I18n.getText('appswitcher.suggestion.jira.desc')},
                       {appName:"confluence",appDesc:AJS.I18n.getText('appswitcher.suggestion.confluence.desc')},
                       {appName:"bamboo", appDesc:AJS.I18n.getText('appswitcher.suggestion.bamboo.desc')}];

    var storeUserStorageData = function (key, value) {
        $.ajax({
            url: AJS.contextPath() + '/rest/menu/latest/userdata/',
            type: "PUT",
            contentType: "application/json",
            data: JSON.stringify({
                key: key,
                value:value
            })
        });
    };

    if (NL.onInit) {
        NL.onInit();
    }


}(jQuery, window.NL = (window.NL || {})));